/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.tree;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.openide.util.Exceptions;
import org.sdrinovsky.sdsvn.SVNApp;
import org.sdrinovsky.sdsvn.dialogs.LoginDialog;
import org.sdrinovsky.sdsvn.tree.RepoNodeData;
import org.sdrinovsky.sdsvn.tree.URLChooser;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class RepoTreeView
extends JDialog {
    private String url;
    private boolean recursive = false;
    private DefaultTreeModel model = null;
    private DefaultMutableTreeNode root = null;
    private String selectedRepoPath = null;
    private JButton cancelButton;
    private JButton findButton;
    private JScrollPane jScrollPane1;
    private JButton locationButton;
    private JComboBox locationField;
    private JLabel locationLabel;
    private JPanel locationPanel;
    private JMenuItem miCopy;
    private JMenuItem miCreate;
    private JMenuItem miDelete;
    private JButton okButton;
    private JPopupMenu repoPopupMenu;
    private JTree repoTree;
    private JPanel searchPanel;
    private JTextField searchTextField;
    private JTextField selectedRepoTextField;

    private static void setupLibrary() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    public static DefaultMutableTreeNode createRootNode(String url, boolean recursive) {
        RepoTreeView.setupLibrary();
        try {
            SVNRepository repo = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)url));
            String username = SVNApp.getApplication().getPreferences().get("username", null);
            String password = SVNApp.getApplication().getPreferences().get("password", null);
            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (String)password);
            repo.setAuthenticationManager(authManager);
            return new DefaultMutableTreeNode(new RepoNodeData(repo, recursive));
        }
        catch (SVNException svne) {
            System.err.println("error while creating an SVNRepository for location '" + url + "': " + svne.getMessage());
            return null;
        }
    }

    public static String getRepoPathFromPath(TreePath path) {
        if (path != null) {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            return ((RepoNodeData)selectedNode.getUserObject()).getRepoPath();
        }
        return null;
    }

    public RepoTreeView(Frame owner, boolean modal, String url, boolean recursive) {
        super(owner, modal);
        if (SVNApp.getApplication().getPreferences().get("username", null) == null) {
            SVNApp.getApplication().show(new LoginDialog());
        }
        this.initComponents();
        this.recursive = recursive;
        this.repoTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                RepoTreeView.this.selectedRepoTextField.setText(RepoTreeView.getRepoPathFromPath(e.getPath()));
            }
        });
        this.loadRepo(url, true);
    }

    public TreeModel getModel() {
        return this.model;
    }

    private String getLocationURL() {
        String item = null;
        Object selectedItem = this.locationField.getSelectedItem();
        if (selectedItem != null) {
            item = selectedItem.toString();
            DefaultComboBoxModel cbModel = (DefaultComboBoxModel)this.locationField.getModel();
            if (cbModel.getIndexOf(item) != 0) {
                cbModel.removeElement(item);
                cbModel.insertElementAt(item, 0);
                this.locationField.setSelectedIndex(0);
            }
        }
        return item;
    }

    public void loadRepo(String url, boolean focusSearch) {
        if (url != null && !url.equals(this.url)) {
            this.url = url;
            this.root = RepoTreeView.createRootNode(url, this.recursive);
            this.model = new DefaultTreeModel(this.root);
            this.model.setAsksAllowsChildren(true);
            this.repoTree.setModel(this.model);
            this.repoTree.expandRow(0);
            if (focusSearch) {
                this.searchTextField.requestFocus();
            }
            this.startWorker((DefaultMutableTreeNode)this.model.getRoot());
            this.locationField.setSelectedItem(url);
        }
    }

    private void initComponents() {
        this.repoPopupMenu = new JPopupMenu();
        this.miCreate = new JMenuItem();
        this.miCopy = new JMenuItem();
        this.miDelete = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.repoTree = new JTree();
        this.searchPanel = new JPanel();
        this.searchTextField = new JTextField();
        this.findButton = new JButton();
        this.selectedRepoTextField = new JTextField();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.locationPanel = new JPanel();
        this.locationLabel = new JLabel();
        this.locationButton = new JButton();
        this.locationField = new JComboBox();
        this.repoPopupMenu.setName("repoPopupMenu");
        ResourceMap resourceMap = ((SVNApp)Application.getInstance(SVNApp.class)).getContext().getResourceMap(RepoTreeView.class);
        this.miCreate.setText(resourceMap.getString("miCreate.text", new Object[0]));
        this.miCreate.setName("miCreate");
        this.miCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepoTreeView.this.miCreateActionPerformed(evt);
            }
        });
        this.repoPopupMenu.add(this.miCreate);
        this.miCopy.setText(resourceMap.getString("miCopy.text", new Object[0]));
        this.miCopy.setName("miCopy");
        this.miCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepoTreeView.this.miCopyActionPerformed(evt);
            }
        });
        this.repoPopupMenu.add(this.miCopy);
        this.miDelete.setText(resourceMap.getString("miDelete.text", new Object[0]));
        this.miDelete.setName("miDelete");
        this.miDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepoTreeView.this.miDeleteActionPerformed(evt);
            }
        });
        this.repoPopupMenu.add(this.miDelete);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.jScrollPane1.setName("jScrollPane1");
        this.repoTree.setModel(this.getModel());
        this.repoTree.setComponentPopupMenu(this.repoPopupMenu);
        this.repoTree.setName("repoTree");
        this.repoTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent evt) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent evt) {
                RepoTreeView.this.repoTreeTreeExpanded(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.repoTree);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.searchPanel.setName("searchPanel");
        this.searchTextField.setText(resourceMap.getString("searchTextField.text", new Object[0]));
        this.searchTextField.setName("searchTextField");
        this.searchTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepoTreeView.this.searchTextFieldActionPerformed(evt);
            }
        });
        this.searchTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                RepoTreeView.this.searchTextFieldKeyReleased(evt);
            }
        });
        this.findButton.setText(resourceMap.getString("findButton.text", new Object[0]));
        this.findButton.setName("findButton");
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepoTreeView.this.findButtonActionPerformed(evt);
            }
        });
        this.selectedRepoTextField.setEditable(false);
        this.selectedRepoTextField.setText(resourceMap.getString("selectedRepoTextField.text", new Object[0]));
        this.selectedRepoTextField.setName("selectedRepoTextField");
        this.okButton.setText(resourceMap.getString("okButton.text", new Object[0]));
        this.okButton.setName("okButton");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepoTreeView.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(resourceMap.getString("cancelButton.text", new Object[0]));
        this.cancelButton.setName("cancelButton");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepoTreeView.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout searchPanelLayout = new GroupLayout(this.searchPanel);
        this.searchPanel.setLayout(searchPanelLayout);
        searchPanelLayout.setHorizontalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.searchTextField, -2, 133, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.findButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectedRepoTextField, -1, 360, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addContainerGap()));
        searchPanelLayout.setVerticalGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchPanelLayout.createSequentialGroup().addContainerGap().addGroup(searchPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchTextField, -2, -1, -2).addComponent(this.findButton).addComponent(this.selectedRepoTextField, -2, -1, -2).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.searchPanel, "South");
        this.locationPanel.setName("locationPanel");
        this.locationLabel.setDisplayedMnemonic('R');
        this.locationLabel.setLabelFor(this.locationField);
        this.locationLabel.setText(resourceMap.getString("locationLabel.text", new Object[0]));
        this.locationLabel.setToolTipText(resourceMap.getString("locationLabel.toolTipText", new Object[0]));
        this.locationLabel.setName("locationLabel");
        this.locationButton.setMnemonic('A');
        this.locationButton.setText(resourceMap.getString("locationButton.text", new Object[0]));
        this.locationButton.setName("locationButton");
        this.locationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepoTreeView.this.locationButtonActionPerformed(evt);
            }
        });
        this.locationField.setEditable(true);
        this.locationField.setName("locationField");
        this.locationField.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                RepoTreeView.this.locationFieldItemStateChanged(evt);
            }
        });
        this.locationField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RepoTreeView.this.locationFieldActionPerformed(evt);
            }
        });
        GroupLayout locationPanelLayout = new GroupLayout(this.locationPanel);
        this.locationPanel.setLayout(locationPanelLayout);
        locationPanelLayout.setHorizontalGroup(locationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(locationPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.locationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.locationField, 0, 478, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.locationButton).addContainerGap()));
        locationPanelLayout.setVerticalGroup(locationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(locationPanelLayout.createSequentialGroup().addContainerGap().addGroup(locationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationLabel).addComponent(this.locationButton).addComponent(this.locationField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.locationPanel, "First");
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.close(false);
    }

    private void jTextField1KeyTyped(KeyEvent evt) {
    }

    private void searchTextFieldKeyReleased(KeyEvent evt) {
        this.findNode(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.close(true);
    }

    private void findButtonActionPerformed(ActionEvent evt) {
        this.findNode(true);
    }

    private void repoTreeTreeExpanded(TreeExpansionEvent evt) {
        this.startWorker((DefaultMutableTreeNode)evt.getPath().getLastPathComponent());
    }

    private void locationButtonActionPerformed(ActionEvent evt) {
        this.loadRepo(this.getLocationURL(), true);
    }

    private void locationFieldActionPerformed(ActionEvent evt) {
        this.loadRepo(this.getLocationURL(), false);
    }

    private void miCopyActionPerformed(ActionEvent evt) {
        String current = RepoTreeView.getRepoPathFromPath(this.repoTree.getSelectionPath());
        URLChooser panel = new URLChooser("Enter the destination URL:", current);
        if (JOptionPane.showConfirmDialog(this, panel, "Copy", 2) == 0) {
            try {
                System.out.println("copy to " + panel.getURL());
                SVNCopySource[] sources = new SVNCopySource[]{new SVNCopySource(SVNRevision.HEAD, SVNRevision.BASE, SVNURL.parseURIEncoded((String)current))};
                SVNApp.getApplication().getSVNClientManager().getCopyClient().doCopy(sources, SVNURL.parseURIEncoded((String)panel.getURL()), false, false, true, "SimpleSVN copy", null);
            }
            catch (SVNException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void miDeleteActionPerformed(ActionEvent evt) {
        String current = RepoTreeView.getRepoPathFromPath(this.repoTree.getSelectionPath());
        if (JOptionPane.showConfirmDialog(this, "Are you sure you want to delete " + current, "Confirm Delete", 2) == 0) {
            System.out.println("delete it!");
        }
    }

    private void miCreateActionPerformed(ActionEvent evt) {
        String current = RepoTreeView.getRepoPathFromPath(this.repoTree.getSelectionPath());
        URLChooser panel = new URLChooser("Enter the destination URL:", current);
        if (JOptionPane.showConfirmDialog(this, panel, "Create", 2) == 0) {
            try {
                System.out.println("copy to " + panel.getURL());
                SVNCopySource[] sources = new SVNCopySource[]{new SVNCopySource(SVNRevision.HEAD, SVNRevision.BASE, SVNURL.parseURIEncoded((String)current))};
                SVNApp.getApplication().getSVNClientManager().getCopyClient().doCopy(sources, SVNURL.parseURIEncoded((String)panel.getURL()), false, false, true, "SimpleSVN copy", null);
            }
            catch (SVNException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void locationFieldItemStateChanged(ItemEvent evt) {
        this.loadRepo(this.getLocationURL(), true);
    }

    private void searchTextFieldActionPerformed(ActionEvent evt) {
        if (this.findNode(false)) {
            this.close(true);
        }
    }

    protected void close(boolean selected) {
        this.selectedRepoPath = selected ? RepoTreeView.getRepoPathFromPath(this.repoTree.getSelectionPath()) : null;
        this.searchTextField.requestFocus();
        this.setVisible(false);
    }

    protected void startWorker(final DefaultMutableTreeNode node) {
        if (node != null && node.getChildCount() > 0) {
            return;
        }
        final RepoNodeData data = (RepoNodeData)node.getUserObject();
        if (data.isLoaded()) {
            return;
        }
        data.startLoading();
        this.model.nodeChanged(node);
        SwingWorker<DefaultMutableTreeNode[], Void> worker = new SwingWorker<DefaultMutableTreeNode[], Void>(){

            @Override
            protected DefaultMutableTreeNode[] doInBackground() throws Exception {
                TreeSet<SVNDirEntry> entries = new TreeSet<SVNDirEntry>();
                DefaultMutableTreeNode[] nodes = null;
                try {
                    data.getChildEntries(entries);
                    nodes = new DefaultMutableTreeNode[entries.size()];
                    int i = 0;
                    for (SVNDirEntry entry : entries) {
                        RepoNodeData newData = new RepoNodeData(data.getRepository(), data, entry, true);
                        nodes[i] = new DefaultMutableTreeNode(newData);
                        nodes[i].setAllowsChildren(newData.isFolder());
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return nodes;
            }

            @Override
            protected void done() {
                try {
                    data.stopLoading();
                    DefaultMutableTreeNode[] children = (DefaultMutableTreeNode[])this.get();
                    for (int i = 0; children != null && i < children.length; ++i) {
                        node.insert(children[i], i);
                    }
                    RepoTreeView.this.model.nodeStructureChanged(node);
                    RepoTreeView.this.model.nodeChanged(node);
                }
                catch (InterruptedException ex) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        };
        worker.execute();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RepoTreeView view = new RepoTreeView(null, true, "https://svn.java.net/svn/sdsvn~svn", true);
                view.setVisible(true);
                System.out.println("selected repo: " + view.getSelectedPath());
                view.dispose();
            }
        });
    }

    public String getSelectedPath() {
        return this.selectedRepoPath;
    }

    public boolean findNode(boolean next) {
        TreeNode node = null;
        TreePath path = this.repoTree.getSelectionPath();
        if (path != null) {
            node = (TreeNode)path.getLastPathComponent();
        }
        if (node == null) {
            node = this.root;
        }
        return this.findNode((DefaultMutableTreeNode)node, next);
    }

    public boolean findNode(DefaultMutableTreeNode start, boolean next) {
        DefaultMutableTreeNode found = this.findNodeByName(this.searchTextField.getText(), start, next);
        if (found != null) {
            TreePath path = new TreePath(this.model.getPathToRoot(found));
            this.repoTree.scrollPathToVisible(path);
            this.repoTree.setSelectionPath(path);
            return true;
        }
        Toolkit.getDefaultToolkit().beep();
        if (start != this.root) {
            this.findNode(this.root, false);
        }
        return false;
    }

    private DefaultMutableTreeNode findNodeByName(String name, DefaultMutableTreeNode node, boolean next) {
        DefaultMutableTreeNode nextNode;
        if (!next && node.toString().toLowerCase().contains(name.toLowerCase())) {
            return node;
        }
        String text = node.toString();
        if ("trunk".equals(text) || "branches".equals(text) || "tags".equals(text)) {
            this.startWorker(node);
        }
        if ((nextNode = node.getNextNode()) != null) {
            return this.findNodeByName(name, node.getNextNode(), false);
        }
        return null;
    }
}

