/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.tree;

import java.util.Collection;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.io.SVNRepository;

public class RepoNodeData {
    private SVNRepository repository;
    private RepoNodeData parent;
    private SVNDirEntry path;
    private boolean recursive;
    private boolean loading = false;
    private boolean loaded = false;

    public RepoNodeData(SVNRepository repository, boolean recursive) {
        this.repository = repository;
        this.recursive = recursive;
    }

    public RepoNodeData(SVNRepository repository, RepoNodeData parent, SVNDirEntry path, boolean recursive) {
        this.repository = repository;
        this.parent = parent;
        this.path = path;
        this.recursive = recursive;
    }

    public SVNRepository getRepository() {
        return this.repository;
    }

    public void getChildEntries(Collection<SVNDirEntry> entries) throws SVNException {
        this.repository.getDir(this.getPath(), -1L, null, entries);
    }

    public String getPath() {
        String string = "";
        if (this.parent != null) {
            string = string + this.parent.getPath() + "/";
        }
        if (this.path != null) {
            string = string + this.path.getRelativePath();
        }
        return string;
    }

    public String getRepoPath() {
        String string = "";
        if (this.parent != null) {
            string = string + this.parent.getRepoPath() + "/";
        }
        string = this.path != null ? string + this.path.getRelativePath() : string + this.repository.getLocation().toString();
        return string;
    }

    public boolean isFolder() {
        return this.path == null || this.path.getKind() == SVNNodeKind.DIR;
    }

    public void startLoading() {
        this.loaded = true;
        this.loading = true;
    }

    public void stopLoading() {
        this.loading = false;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public String toString() {
        String text = null;
        text = this.path != null ? this.path.getRelativePath() : this.repository.getLocation().toString();
        if (this.loading) {
            text = text + " (loading...)";
        }
        return text;
    }
}

