/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.tasks;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.Task;
import org.sdrinovsky.sdsvn.SVNApp;
import org.sdrinovsky.sdsvn.files.FileRow;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class UpdateTask
extends Task<Void, Void> {
    SVNUpdateClient updateClient;
    List<? extends FileRow> rows;
    SVNRevision revision;
    long[] revisionNumbers;

    public UpdateTask(SVNApp app, List<? extends FileRow> rows) {
        this(app, rows, SVNRevision.HEAD);
    }

    public UpdateTask(SVNApp app, List<? extends FileRow> rows, SVNRevision revision) {
        super((Application)app);
        this.updateClient = app.getSVNClientManager().getUpdateClient();
        this.updateClient.setEventHandler(new ISVNEventHandler(){

            public void handleEvent(SVNEvent event, double progress) throws SVNException {
                if (progress >= 0.0) {
                    UpdateTask.this.setProgress((float)progress);
                }
                if (event.getFile() != null) {
                    UpdateTask.this.setMessage(event.getFile().toString());
                } else {
                    System.out.println("getFile() returned null!");
                }
            }

            public void checkCancelled() throws SVNCancelException {
            }
        });
        this.rows = rows;
        this.revision = revision;
    }

    protected Void doInBackground() throws Exception {
        File[] destinations = new File[this.rows.size()];
        for (int i = 0; i < destinations.length; ++i) {
            destinations[i] = this.rows.get(i).getFile();
        }
        if (destinations.length > 1 || !destinations[0].isDirectory() || new File(destinations[0], ".svn").exists()) {
            this.revisionNumbers = this.updateClient.doUpdate(destinations, this.revision, SVNDepth.UNKNOWN, false, false);
        }
        return null;
    }

    protected void succeeded(Void result) {
        if (this.revisionNumbers != null && this.revisionNumbers.length == 1) {
            this.firePropertyChange("refresh", null, "Update Finished. Updated to revision " + this.revisionNumbers[0]);
        } else {
            this.firePropertyChange("refresh", null, "Update Finished.");
        }
    }

    protected void failed(Throwable cause) {
        this.firePropertyChange("error", null, "Update Failed: " + cause.getMessage());
        Logger.getLogger(UpdateTask.class.getName()).log(Level.WARNING, null, cause);
    }
}

