/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.tasks;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.Task;
import org.sdrinovsky.sdsvn.SVNApp;
import org.sdrinovsky.sdsvn.files.FileTableRow;
import org.sdrinovsky.sdsvn.tasks.CheckoutTask;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class RevertTask
extends Task<Void, Void> {
    List<FileTableRow> selected;
    SVNWCClient wcClient;
    SVNRevision revision;

    public RevertTask(SVNApp app, List<FileTableRow> files) {
        this(app, files, null);
    }

    public RevertTask(SVNApp app, List<FileTableRow> selected, SVNRevision revision) {
        super((Application)app);
        this.wcClient = app.getSVNClientManager().getWCClient();
        this.wcClient.setEventHandler(new ISVNEventHandler(){

            public void handleEvent(SVNEvent event, double progress) throws SVNException {
                RevertTask.this.setMessage(event.getFile().toString());
            }

            public void checkCancelled() throws SVNCancelException {
            }
        });
        this.selected = selected;
    }

    protected Void doInBackground() throws Exception {
        LinkedList<File> files = new LinkedList<File>();
        int counter = 0;
        int total = this.selected.size();
        for (FileTableRow row : this.selected) {
            if (++counter <= total) {
                this.setProgress((float)counter / (float)total);
            }
            File file = row.getFile();
            files.add(file);
            if (!file.isFile()) continue;
            File backFile = new File(file.getParentFile(), file.getName() + "~");
            if (backFile.exists()) {
                backFile.delete();
            }
            file.renameTo(backFile);
        }
        this.wcClient.doRevert(files.toArray(new File[files.size()]), SVNDepth.EMPTY, null);
        return null;
    }

    protected void succeeded(Void result) {
        this.firePropertyChange("refresh", null, "Revert Finished");
    }

    protected void failed(Throwable cause) {
        this.firePropertyChange("refresh", null, "Revert Failed: " + cause.getMessage());
        Logger.getLogger(CheckoutTask.class.getName()).log(Level.WARNING, null, cause);
    }
}

