/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.tasks;

import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jdesktop.application.Application;
import org.jdesktop.application.Task;
import org.sdrinovsky.sdsvn.SVNApp;
import org.sdrinovsky.sdsvn.files.FileTableRow;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class ResolveTask
extends Task<Void, Void> {
    List<FileTableRow> files;
    SVNWCClient wcClient;
    SVNApp app;

    public ResolveTask(SVNApp app, List<FileTableRow> files) {
        super((Application)app);
        this.files = files;
        this.app = app;
        this.wcClient = app.getSVNClientManager().getWCClient();
    }

    protected Void doInBackground() throws Exception {
        int counter = 0;
        int total = this.files.size();
        for (FileTableRow f : this.files) {
            if (++counter <= total) {
                this.setProgress((float)counter / (float)total);
            }
            this.wcClient.doResolve(f.getFile(), SVNDepth.EMPTY, SVNConflictChoice.MERGED);
        }
        return null;
    }

    protected void failed(Throwable t) {
        this.setMessage("Resolve failed.");
        JTextArea textArea = new JTextArea();
        textArea.setRows(15);
        textArea.setColumns(75);
        textArea.setLineWrap(false);
        textArea.setText(t.getMessage());
        textArea.setCaretPosition(0);
        JScrollPane pane = new JScrollPane(textArea);
        JOptionPane.showMessageDialog(this.app.getMainFrame(), pane, "Resolve Task Failed", 0);
    }

    protected void succeeded(Void result) {
        this.firePropertyChange("refresh", null, "Resolve finished.");
    }
}

