/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.tasks;

import java.io.File;
import java.io.FilenameFilter;
import java.util.LinkedList;
import java.util.List;
import org.jdesktop.application.Application;
import org.jdesktop.application.Task;
import org.sdrinovsky.sdsvn.SVNApp;
import org.sdrinovsky.sdsvn.files.FileTableRow;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;

public class RefreshTask
extends Task<Void, Void> {
    SVNStatusClient statusClient;
    File workingCopy;
    List<File> selected;
    boolean remote;
    String item;
    String message;
    long start;
    List<FileTableRow> rows = new LinkedList<FileTableRow>();
    ISVNStatusHandler handler = new ISVNStatusHandler(){

        public void handleStatus(SVNStatus status) throws SVNException {
            RefreshTask.this.rows.add(new FileTableRow(status));
        }
    };

    public RefreshTask(SVNApp app, File workingCopy, List<File> selected, boolean remote) {
        super((Application)app);
        this.statusClient = app.getSVNClientManager().getStatusClient();
        this.workingCopy = workingCopy;
        this.selected = selected;
        this.remote = remote;
    }

    public void setMessageText(String message) {
        this.message = message;
    }

    protected Void doInBackground() throws Exception {
        this.start = System.currentTimeMillis();
        this.setMessage("Refreshing " + this.workingCopy);
        if (new File(this.workingCopy, ".svn").exists()) {
            this.doStatus(this.workingCopy);
        } else {
            String[] subfolders = this.workingCopy.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return new File(dir, name).isDirectory();
                }
            });
            if (subfolders == null || subfolders.length == 0) {
                throw new Exception("No working copy found");
            }
            for (String file : this.workingCopy.list()) {
                this.doStatus(new File(this.workingCopy, file));
            }
        }
        return null;
    }

    private void doStatus(File file) throws SVNException {
        this.statusClient.doStatus(file, SVNRevision.UNDEFINED, SVNDepth.UNKNOWN, this.remote, true, true, true, this.handler, null);
    }

    protected void finished() {
        this.firePropertyChange("status", null, this.rows);
        for (FileTableRow row : this.rows) {
            if (!this.selected.contains(row.getFile())) continue;
            this.firePropertyChange("selected", null, row);
        }
    }

    protected void succeeded(Void arg0) {
        if (this.message != null) {
            this.setMessage(this.message);
        } else {
            long finish = System.currentTimeMillis() - this.start;
            this.setMessage("Refresh Finished in " + finish + "ms");
        }
    }

    protected void failed(Throwable t) {
        if (t instanceof SVNException) {
            SVNException ex = (SVNException)t;
            this.firePropertyChange("error", null, "Unable to refresh: " + ex.getErrorMessage().getMessage());
        } else {
            this.firePropertyChange("error", null, "Unexpected Error: " + t.getClass().getName() + ": " + t.getMessage());
        }
    }
}

