/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.tasks;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.jdesktop.application.Application;
import org.jdesktop.application.Task;
import org.sdrinovsky.sdsvn.SVNApp;
import org.sdrinovsky.sdsvn.files.FileTableRow;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class PropertiesTask
extends Task<List<SVNPropertyData>, Void> {
    SVNApp app;
    FileTableRow row;

    public PropertiesTask(SVNApp app, FileTableRow row) {
        super((Application)app);
        this.app = app;
        this.row = row;
    }

    protected List<SVNPropertyData> doInBackground() throws SVNException {
        LinkedList<SVNPropertyData> properties = new LinkedList<SVNPropertyData>();
        this.app.getSVNClientManager().getWCClient().doGetProperty(this.row.getFile(), null, SVNRevision.UNDEFINED, SVNRevision.UNDEFINED, SVNDepth.EMPTY, (ISVNPropertyHandler)new PropertyHandler(properties), null);
        return properties;
    }

    protected void succeeded(List<SVNPropertyData> properties) {
        Object[][] data = new Object[properties.size()][2];
        int index = 0;
        for (SVNPropertyData propertyData : properties) {
            data[index][0] = propertyData.getName();
            data[index][1] = propertyData.getValue();
            ++index;
        }
        JDialog dialog = new JDialog((Frame)this.app.getMainFrame(), false);
        JTable table = new JTable(data, new Object[]{"Name", "Value"});
        dialog.getContentPane().add((Component)new JScrollPane(table), "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = 500;
        int height = 250;
        dialog.setBounds((screenSize.width - width) / 2, (screenSize.height - height) / 2, width, height);
        dialog.setTitle("SVN Properties - " + this.row.getFileName());
        dialog.setVisible(true);
    }

    protected void failed(Throwable arg0) {
        JOptionPane.showMessageDialog(null, arg0.getMessage());
    }

    class PropertyHandler
    implements ISVNPropertyHandler {
        List<SVNPropertyData> properties;

        public PropertyHandler(List<SVNPropertyData> properties) {
            this.properties = properties;
        }

        public void handleProperty(File path, SVNPropertyData property) throws SVNException {
            this.properties.add(property);
        }

        public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
            this.properties.add(property);
        }

        public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
            this.properties.add(property);
        }
    }
}

