/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.tasks;

import java.awt.Cursor;
import java.awt.Frame;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.Task;
import org.sdrinovsky.sdsvn.SVNApp;
import org.sdrinovsky.sdsvn.dialogs.HistoryDialog;
import org.sdrinovsky.sdsvn.files.FileRow;
import org.sdrinovsky.sdsvn.files.Location;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class MergeTask
extends Task<Void, Void> {
    SVNApp app;
    SVNDiffClient diffClient;
    SVNURL start;
    SVNURL from;
    List<? extends FileRow> rows;
    SVNRevision revision;
    List<SVNRevisionRange> mergeRevisions;

    public MergeTask(SVNApp app, List<? extends FileRow> rows, SVNRevision revision) {
        super((Application)app);
        this.app = app;
        this.rows = rows;
        this.revision = revision;
        this.diffClient = app.getSVNClientManager().getDiffClient();
        this.diffClient.setEventHandler(new ISVNEventHandler(){

            public void handleEvent(SVNEvent event, double progress) throws SVNException {
                if (MergeTask.this.isCancelled()) {
                    throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CANCELLED, (String)"Merge task canceled"));
                }
                if (event.getFile() != null && event.getContentsStatus() != SVNStatusType.INAPPLICABLE) {
                    MergeTask.this.setMessage(event.getFile().toString() + ": " + event.getContentsStatus());
                }
            }

            public void checkCancelled() throws SVNCancelException {
            }
        });
    }

    public MergeTask(SVNApp app, SVNURL start, List<FileRow> rows, SVNURL from, SVNRevision revision) {
        this(app, rows, revision);
        this.start = start;
        this.from = from;
        try {
            if (rows.size() > 0) {
                this.mergeRevisions = this.getEligible(rows.get(0));
            }
        }
        catch (SVNException ex) {
            Logger.getLogger(MergeTask.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected Void doInBackground() throws Exception {
        int counter = 0;
        int total = this.rows.size();
        for (FileRow fileRow : this.rows) {
            if (++counter <= total) {
                this.setProgress((float)counter / (float)total);
            }
            File destination = fileRow.getFile();
            this.doMerge(destination, "");
        }
        return null;
    }

    private List<SVNRevisionRange> getEligible(FileRow row) throws SVNException {
        File destination = row.getFile();
        Location location = row.getLocation();
        this.app.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
        SVNURL url = SVNURL.parseURIDecoded((String)this.start.toString());
        final LinkedList<SVNLogEntry> entries = new LinkedList<SVNLogEntry>();
        this.diffClient.doGetLogEligibleMergeInfo(destination, SVNRevision.HEAD, url, SVNRevision.HEAD, true, null, new ISVNLogEntryHandler(){

            public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                entries.add(logEntry);
            }
        });
        HistoryDialog dialog = new HistoryDialog((Frame)this.app.getMainFrame(), true);
        dialog.setFileRow(location, true, false, false);
        dialog.setLog(entries);
        dialog.setCommittedRevision(this.revision.getNumber(), false);
        dialog.setTitle("SVN Merge Revision Listing");
        dialog.setAcceptText("Merge");
        dialog.setMultiSelect(true);
        this.app.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
        dialog.setVisible(true);
        if (dialog.didAccept()) {
            return dialog.getSelectedRevisions();
        }
        return null;
    }

    private void doMerge(File destination, String path) throws Exception {
        if (this.start == null) {
            this.doRevert(destination, path);
        } else if (this.mergeRevisions != null) {
            SVNURL url = SVNURL.parseURIDecoded((String)(this.start.toString() + path));
            File file = new File(destination, path);
            this.diffClient.doMerge(url, SVNRevision.HEAD, this.mergeRevisions, file, SVNDepth.UNKNOWN, true, false, false, false);
        } else {
            this.cancel(true);
        }
    }

    private void doRevert(File destination, String path) throws Exception {
        File file = new File(destination, path);
        this.diffClient.doMerge(file, this.revision, file, SVNRevision.create((long)(this.revision.getNumber() - 1L)), file, SVNDepth.UNKNOWN, false, false, false, false);
    }

    protected void succeeded(Void result) {
        String revisions = "";
        if (this.mergeRevisions != null) {
            for (SVNRevisionRange range : this.mergeRevisions) {
                if (revisions.length() > 0) {
                    revisions = revisions + ", ";
                }
                long startRevision = range.getStartRevision().getNumber();
                long endRevision = range.getEndRevision().getNumber();
                if (endRevision - startRevision == 1L) {
                    revisions = revisions + startRevision;
                    continue;
                }
                revisions = revisions + startRevision + "-" + endRevision;
            }
        }
        this.firePropertyChange("refresh", null, "Succeded merging revisions " + revisions);
    }

    protected void finished() {
        if (this.isCancelled()) {
            this.firePropertyChange("refresh", null, "Merge Canceled.");
        }
    }

    protected void failed(Throwable cause) {
        this.firePropertyChange("refresh", null, "Merge Failed: " + cause.getMessage());
        Logger.getLogger(MergeTask.class.getName()).log(Level.WARNING, null, cause);
    }
}

