/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.tasks;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdesktop.application.Application;
import org.jdesktop.application.Task;
import org.sdrinovsky.sdsvn.SVNApp;
import org.sdrinovsky.sdsvn.dialogs.HistoryDialog;
import org.sdrinovsky.sdsvn.files.FileTableRow;
import org.sdrinovsky.sdsvn.files.Location;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class HistoryTask
extends Task<List<SVNLogEntry>, Void> {
    SVNApp app;
    Location location;
    FileTableRow row;
    DefaultTableCellRenderer coloredRenderer = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int r, int c) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, r, c);
            Long rev = (Long)table.getModel().getValueAt(table.convertRowIndexToModel(r), 0);
            if (HistoryTask.this.row.getCommitRevision() == rev.longValue()) {
                comp.setForeground(Color.blue);
            } else {
                comp.setForeground(Color.black);
            }
            return comp;
        }
    };

    public HistoryTask(SVNApp app, Location location, FileTableRow row) {
        super((Application)app);
        this.app = app;
        this.location = location;
        this.row = row;
    }

    protected List<SVNLogEntry> doInBackground() throws Exception {
        final LinkedList<SVNLogEntry> history = new LinkedList<SVNLogEntry>();
        int total = 250;
        this.app.getSVNClientManager().getLogClient().doLog(new File[]{this.row.getFile()}, SVNRevision.HEAD, SVNRevision.create((long)1L), false, true, 250L, new ISVNLogEntryHandler(){
            int counter = 0;

            public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                ++this.counter;
                if (this.counter <= 250) {
                    HistoryTask.this.setProgress((float)this.counter / 250.0f);
                }
                HistoryTask.this.setMessage("getting revision " + logEntry.getRevision());
                history.add(logEntry);
            }
        });
        return history;
    }

    protected void succeeded(List<SVNLogEntry> history) {
        HistoryDialog dialog = new HistoryDialog((Frame)this.app.getMainFrame(), false);
        dialog.setFileRow(this.location, true, true, true);
        dialog.setLog(history);
        dialog.setCommittedRevision(this.row.getCommitRevision(), this.row.isCommitable());
        dialog.setTitle("SVN History - " + this.row.getFileName());
        dialog.setVisible(true);
    }

    protected void failed(Throwable arg0) {
        JOptionPane.showMessageDialog(null, arg0.getMessage());
    }
}

