/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.tasks;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.Task;
import org.sdrinovsky.sdsvn.SVNApp;
import org.sdrinovsky.sdsvn.files.FileTableRow;
import org.sdrinovsky.sdsvn.files.Location;
import org.sdrinovsky.sdsvn.graph.GraphLogEntry;
import org.sdrinovsky.sdsvn.graph.GraphTree;
import org.sdrinovsky.sdsvn.graph.GraphView;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class GraphTask
extends Task<Map<String, List<GraphLogEntry>>, Void> {
    FileTableRow row;
    Location location;
    List<String> branches;
    Set<Long> revisions = new HashSet<Long>();
    SVNLogClient logClient;
    long starttime = 0L;
    int current = 0;
    int max = 0;
    float step = 0.0f;

    public GraphTask(SVNApp app, FileTableRow row, Location location, List<String> folders) {
        super((Application)app);
        this.row = row;
        this.location = location;
        this.branches = folders;
        this.logClient = app.getSVNClientManager().getLogClient();
        this.max = this.branches.size();
        this.step = 1.0f / (float)this.max;
    }

    protected Map<String, List<GraphLogEntry>> doInBackground() throws Exception {
        this.starttime = System.currentTimeMillis();
        HashMap<String, List<GraphLogEntry>> entries = new HashMap<String, List<GraphLogEntry>>();
        for (String branch : this.branches) {
            LinkedList<GraphLogEntry> list = new LinkedList<GraphLogEntry>();
            entries.put(branch, list);
            String url = this.row.getLocation().getURL();
            url = FileTableRow.switchBranch(url, branch);
            Handler handler = new Handler(this.row.getFile(), url, branch, list);
            System.out.println("graph url " + ++this.current + " of " + this.max + ": " + url);
            try {
                this.logClient.doLog(SVNURL.parseURIDecoded((String)url), null, SVNRevision.UNDEFINED, SVNRevision.HEAD, SVNRevision.create((long)0L), true, true, Long.MAX_VALUE, (ISVNLogEntryHandler)handler);
                long previous = 0L;
                long last = handler.getLastEntry().getRevision();
                while (previous != last && this.revisions.size() > 0 && !this.revisions.contains(last)) {
                    previous = last;
                    this.logClient.doLog(SVNURL.parseURIDecoded((String)url), null, SVNRevision.UNDEFINED, SVNRevision.create((long)last), SVNRevision.create((long)0L), false, true, 2L, (ISVNLogEntryHandler)handler);
                    last = handler.getLastEntry().getRevision();
                }
                this.revisions.addAll(handler.getAddedRevisions());
            }
            catch (SVNException svne) {
                Logger.getLogger(GraphTask.class.getName()).log(Level.SEVERE, null, svne);
            }
        }
        return entries;
    }

    protected void succeeded(Map<String, List<GraphLogEntry>> result) {
        this.setMessage("Building Graph...");
        GraphTree root = new GraphTree(this.row.getFileName());
        GraphTree tree = null;
        for (String branch : this.branches) {
            tree = null;
            for (GraphLogEntry entry : result.get(branch)) {
                if (tree == null) {
                    tree = new GraphTree(entry);
                    continue;
                }
                tree = new GraphTree(entry, tree);
            }
            if (tree == null) continue;
            root.add(new GraphTree(branch, tree));
        }
        new GraphView(this.row, this.location, root).setVisible(true);
        String message = "Graph of " + this.row + " finished (" + (double)(System.currentTimeMillis() - this.starttime) / 1000.0 + ").";
        this.setMessage(message);
        System.out.println(message);
    }

    protected void failed(Throwable cause) {
        this.setMessage("Failed to graph " + this.row + ": " + cause.getMessage());
        Logger.getLogger(GraphTask.class.getName()).log(Level.WARNING, null, cause);
    }

    class Handler
    implements ISVNLogEntryHandler {
        private File file;
        private String url;
        private String branch;
        private List<GraphLogEntry> entries;
        private long firstEntry = -1L;
        private Set<Long> localRevisions = new HashSet<Long>();
        private SVNLogEntry last = null;

        public Handler(File file, String url, String branch, List<GraphLogEntry> entries) {
            this.file = file;
            this.url = url;
            this.branch = branch;
            this.entries = entries;
        }

        public void handleLogEntry(SVNLogEntry svnLogEntry) throws SVNException {
            float progress = (float)(GraphTask.this.current - 1) * GraphTask.this.step;
            if (progress < 0.0f) {
                progress = 0.0f;
            } else if (progress > 1.0f) {
                progress = 1.0f;
            }
            if (this.firstEntry == -1L) {
                this.firstEntry = svnLogEntry.getRevision();
                GraphTask.this.setProgress(progress);
            } else {
                float f1 = this.firstEntry;
                float f2 = svnLogEntry.getRevision();
                GraphTask.this.setProgress(progress + (f1 - f2) / f1 * GraphTask.this.step);
            }
            Location location = new Location(this.file, this.url);
            GraphLogEntry node = new GraphLogEntry(svnLogEntry, location);
            if (!this.entries.contains(node)) {
                System.out.println("adding revision " + svnLogEntry.getRevision() + " for url " + location.getPath());
                this.entries.add(node);
                GraphTask.this.setMessage(this.file + "@" + this.branch + ": adding revision " + svnLogEntry.getRevision());
                this.localRevisions.add(svnLogEntry.getRevision());
            }
            this.last = svnLogEntry;
        }

        public SVNLogEntry getLastEntry() {
            return this.last;
        }

        public Set<Long> getAddedRevisions() {
            return this.localRevisions;
        }

        private boolean fileInPaths(SVNLogEntry svnLogEntry, String path) {
            for (Object key : svnLogEntry.getChangedPaths().keySet()) {
                if (!key.toString().endsWith(path) || svnLogEntry.getChangedPaths().get(key).toString().indexOf(40) >= 0) continue;
                return true;
            }
            return false;
        }
    }
}

