/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.tasks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import org.jdesktop.application.Application;
import org.jdesktop.application.Task;
import org.sdrinovsky.sdsvn.SVNApp;
import org.sdrinovsky.sdsvn.files.FileRow;
import org.sdrinovsky.sdsvn.files.FileTableRow;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class DiffTask
extends Task<Void, Void> {
    SVNApp app;
    List<? extends FileRow> rows;
    boolean diffTogether = false;
    SVNRevision revision1;
    SVNRevision revision2;
    PropertyHandler propertyHandler = new PropertyHandler();

    public DiffTask(SVNApp app, List<? extends FileRow> rows) {
        this(app, rows, false);
    }

    public DiffTask(SVNApp app, List<? extends FileRow> rows, boolean diffTogether) {
        this(app, rows, null, null);
        this.diffTogether = diffTogether;
    }

    public DiffTask(SVNApp app, List<? extends FileRow> rows, SVNRevision revision) {
        this(app, rows, revision, null);
    }

    public DiffTask(SVNApp app, List<? extends FileRow> rows, SVNRevision revision1, SVNRevision revision2) {
        super((Application)app);
        this.app = app;
        this.rows = rows;
        this.revision1 = revision1;
        this.revision2 = revision2;
    }

    protected Void doInBackground() throws Exception {
        String diffProgram = this.app.getPreferences().get("diffProgram", null);
        String mergeProgram = this.app.getPreferences().get("mergeProgram", null);
        if (diffProgram != null) {
            if (this.revision1 != null) {
                this.diffWithRepo(diffProgram);
            } else if (!this.diffTogether) {
                this.diffWithTextBase(diffProgram, mergeProgram);
                this.diffProperties(diffProgram);
            } else {
                this.diffTogether(diffProgram);
            }
        } else {
            this.setMessage("No diff program set");
        }
        return null;
    }

    private File getMergeFile(final File file, final String match) {
        File[] files = file.getParentFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(file.getName() + "." + match);
            }
        });
        if (files != null && files.length == 1) {
            return files[0];
        }
        return null;
    }

    private void diffWithTextBase(String diffProgram, String mergeProgram) throws IOException {
        int counter = 0;
        int total = this.rows.size();
        for (FileRow fileRow : this.rows) {
            File file;
            int rc;
            if (++counter <= total) {
                this.setProgress((float)counter / (float)total);
            }
            if (FileTableRow.isConflicted(fileRow.getStatus()) && mergeProgram != null && (rc = JOptionPane.showConfirmDialog(this.app.getMainFrame(), "Did you want to do a three way merge?", "Conflicts found for " + fileRow.getFile().getName(), 0)) == 0) {
                File f1 = this.getMergeFile(fileRow.getFile(), "merge-left");
                File f2 = fileRow.getFile();
                File f3 = this.getMergeFile(fileRow.getFile(), "merge-right");
                Runtime.getRuntime().exec(new String[]{mergeProgram, f1.getPath(), f2.getPath(), f3.getPath()});
                this.setMessage("merging local changes in " + fileRow.getFile());
                break;
            }
            if (!FileTableRow.isModified(fileRow.getStatus()) || !(file = fileRow.getFile()).isFile()) continue;
            File parent = file.getParentFile();
            File svn = new File(parent, ".svn/text-base");
            if (svn.exists()) {
                File base = new File(svn, file.getName() + ".svn-base");
                File baseTmp = File.createTempFile("svn-base", "." + file.getName());
                DiffTask.copyTo(base, baseTmp);
                baseTmp.deleteOnExit();
                baseTmp.setReadOnly();
                Runtime.getRuntime().exec(new String[]{diffProgram, baseTmp.getPath(), file.getPath()});
            }
            this.setMessage("diffing local changes in " + fileRow.getFile());
        }
    }

    private void diffWithRepo(String diffProgram) throws SVNException, IOException {
        SVNUpdateClient client = this.app.getSVNClientManager().getUpdateClient();
        int counter = 0;
        int total = this.rows.size();
        for (FileRow fileRow : this.rows) {
            if (++counter <= total) {
                this.setProgress((float)counter / (float)total);
            }
            File file1 = fileRow.getFile();
            SVNURL url2 = SVNURL.parseURIDecoded((String)fileRow.getLocation().getURL());
            File svn1 = File.createTempFile("diff" + file1.getName(), ".r" + this.revision1);
            File svn2 = file1;
            String diffFileOne = "";
            String diffFileTwo = "";
            diffFileOne = this.revision2 != null ? url2 + "@" + this.revision2 : file1.getPath();
            diffFileTwo = url2 + "@" + this.revision1;
            this.setMessage("diffing " + diffFileOne + " with " + diffFileTwo);
            client.doExport(url2, svn1, SVNRevision.UNDEFINED, this.revision1, null, true, SVNDepth.UNKNOWN);
            if (svn1.exists()) {
                svn1.deleteOnExit();
                svn1.setReadOnly();
            }
            if (file1.isDirectory() || this.revision2 != null) {
                if (this.revision2 != null) {
                    svn2 = File.createTempFile("diff" + file1.getName(), ".r" + this.revision2);
                }
                if (file1.isDirectory()) {
                    client.doExport(SVNURL.parseURIDecoded((String)fileRow.getLocation().getURL()), svn2, SVNRevision.UNDEFINED, this.revision2, null, true, SVNDepth.IMMEDIATES);
                } else {
                    client.doExport(url2, svn2, SVNRevision.UNDEFINED, this.revision2, null, true, SVNDepth.UNKNOWN);
                }
                if (svn2.exists()) {
                    svn2.deleteOnExit();
                    svn2.setReadOnly();
                }
            }
            if (!svn1.exists() || !svn2.exists()) continue;
            Runtime.getRuntime().exec(new String[]{diffProgram, svn1.getPath(), svn2.getPath()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void diffProperties(String diffProgram) throws SVNException, IOException {
        int counter = 0;
        int total = this.rows.size();
        for (FileRow fileRow : this.rows) {
            if (++counter <= total) {
                this.setProgress((float)counter / (float)total);
            }
            if (!FileTableRow.isPropertyModified(fileRow.getStatus())) continue;
            File file = fileRow.getFile();
            File svn1 = File.createTempFile("diff" + file.getName() + ".properties", ".wc");
            File svn2 = File.createTempFile("diff" + file.getName() + ".properties", ".base");
            TreeMap<String, String> currentProps = new TreeMap<String, String>();
            TreeMap<String, String> baseProps = new TreeMap<String, String>();
            this.propertyHandler.setMap(currentProps);
            this.app.getSVNClientManager().getWCClient().doGetProperty(fileRow.getFile(), null, SVNRevision.UNDEFINED, SVNRevision.WORKING, SVNDepth.EMPTY, (ISVNPropertyHandler)this.propertyHandler, null);
            this.propertyHandler.setMap(baseProps);
            this.app.getSVNClientManager().getWCClient().doGetProperty(fileRow.getFile(), null, SVNRevision.UNDEFINED, SVNRevision.BASE, SVNDepth.EMPTY, (ISVNPropertyHandler)this.propertyHandler, null);
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(new FileWriter(svn1));
                for (String name : currentProps.keySet()) {
                    pw.println(name + ": " + (String)currentProps.get(name));
                }
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
                pw = null;
            }
            try {
                pw = new PrintWriter(new FileWriter(svn2));
                for (String name : baseProps.keySet()) {
                    pw.println(name + ": " + (String)baseProps.get(name));
                }
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
                pw = null;
            }
            if (svn1.exists() && svn2.exists()) {
                Runtime.getRuntime().exec(new String[]{diffProgram, svn1.getPath(), svn2.getPath()});
            }
            this.setMessage("diffing " + fileRow.getFile());
        }
    }

    private void diffTogether(String diffProgram) throws IOException {
        if (this.rows.size() == 2) {
            Runtime.getRuntime().exec(new String[]{diffProgram, this.rows.get(0).getFile().getPath(), this.rows.get(1).getFile().getPath()});
        }
    }

    protected void finished() {
        this.setMessage("Diff Finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyTo(File from, File to) throws IOException {
        if (!from.exists() || from.getCanonicalPath().equals(to.getCanonicalPath())) {
            return;
        }
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(from));
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(to));
        try {
            int BUFSIZ = 8192;
            byte[] buf = new byte[8192];
            int len = 0;
            while ((len = ((InputStream)is).read(buf)) >= 0) {
                ((OutputStream)os).write(buf, 0, len);
            }
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException ioe) {}
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    class PropertyHandler
    implements ISVNPropertyHandler {
        Map<String, String> properties;

        PropertyHandler() {
        }

        public void setMap(Map<String, String> properties) {
            this.properties = properties;
        }

        public void handleProperty(File path, SVNPropertyData property) throws SVNException {
            if (this.properties != null) {
                this.properties.put(property.getName(), property.getValue().toString());
            }
        }

        public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
            if (this.properties != null) {
                this.properties.put(property.getName(), property.getValue().toString());
            }
        }

        public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
            if (this.properties != null) {
                this.properties.put(property.getName(), property.getValue().toString());
            }
        }
    }
}

