/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.tasks;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jdesktop.application.Application;
import org.jdesktop.application.Task;
import org.sdrinovsky.sdsvn.SVNApp;
import org.sdrinovsky.sdsvn.files.FileTableRow;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNEvent;

public class CommitTask
extends Task<SVNCommitInfo, Void> {
    List<File> files = new LinkedList<File>();
    String message;
    SVNCommitClient commitClient;
    SVNApp app;

    public CommitTask(SVNApp app, List<FileTableRow> rows, String message) {
        super((Application)app);
        for (FileTableRow row : rows) {
            this.files.add(row.getFile());
        }
        this.message = message;
        this.app = app;
        this.commitClient = app.getSVNClientManager().getCommitClient();
    }

    protected SVNCommitInfo doInBackground() throws Exception {
        System.out.println("Committing...");
        final int total = this.files.size() * 2 + 1;
        this.commitClient.setEventHandler(new ISVNEventHandler(){
            int counter = 0;

            public void handleEvent(SVNEvent event, double progress) throws SVNException {
                ++this.counter;
                if (this.counter <= total) {
                    CommitTask.this.setProgress((float)this.counter / (float)total);
                }
                System.out.println(event);
            }

            public void checkCancelled() throws SVNCancelException {
            }
        });
        return this.commitClient.doCommit(this.files.toArray(new File[this.files.size()]), true, this.message, null, null, false, false, SVNDepth.fromRecurse((boolean)false));
    }

    protected void failed(Throwable t) {
        System.err.println(t.getMessage());
        this.setMessage("Commit failed.");
        JTextArea textArea = new JTextArea();
        textArea.setRows(15);
        textArea.setColumns(75);
        textArea.setLineWrap(false);
        textArea.setText(t.getMessage());
        textArea.setCaretPosition(0);
        JScrollPane pane = new JScrollPane(textArea);
        JOptionPane.showMessageDialog(this.app.getMainFrame(), pane);
    }

    protected void succeeded(SVNCommitInfo info) {
        this.firePropertyChange("refresh", null, "Commit finished: revision " + info.getNewRevision());
    }
}

