/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.tasks;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.Task;
import org.sdrinovsky.sdsvn.SVNApp;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class CheckoutTask
extends Task<Void, Void> {
    SVNUpdateClient updateClient;
    SVNURL url;
    File destination;
    SVNRevision revision;
    long revisionNumber = 0L;

    public CheckoutTask(SVNApp app, SVNURL url, File destination, SVNRevision revision) {
        super((Application)app);
        this.updateClient = app.getSVNClientManager().getUpdateClient();
        this.updateClient.setEventHandler(new ISVNEventHandler(){

            public void handleEvent(SVNEvent event, double progress) throws SVNException {
                if (event.getFile() != null) {
                    CheckoutTask.this.setMessage(event.getFile().toString());
                } else {
                    System.out.println("getFile() returned null!");
                }
            }

            public void checkCancelled() throws SVNCancelException {
            }
        });
        this.url = url;
        this.destination = destination;
        this.revision = revision;
    }

    protected Void doInBackground() throws Exception {
        SVNDepth immediates = SVNDepth.EMPTY;
        SVNDepth files = SVNDepth.FILES;
        SVNDepth infinity = SVNDepth.INFINITY;
        this.revisionNumber = this.updateClient.doCheckout(this.url, this.destination, this.revision, this.revision, immediates, false);
        this.updateClient.doUpdate(this.destination, this.revision, infinity, false, true);
        return null;
    }

    protected void succeeded(Void result) {
        this.firePropertyChange("refresh", null, "Checkout Finished. Updated to revision " + this.revisionNumber);
    }

    protected void failed(Throwable cause) {
        this.firePropertyChange("refresh", null, "Checkout Failed: " + cause.getMessage());
        Logger.getLogger(CheckoutTask.class.getName()).log(Level.WARNING, null, cause);
    }
}

