/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.tasks;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.Task;
import org.sdrinovsky.sdsvn.SVNApp;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class BranchTask
extends Task<Void, Void> {
    SVNApp app;
    SVNCopyClient copyClient;
    SVNUpdateClient updateClient;
    File source;
    SVNURL destination;
    long switchRevisionNumber = 0L;

    public BranchTask(SVNApp app, File source, SVNURL destination) {
        super((Application)app);
        this.app = app;
        this.source = source;
        this.destination = destination;
        this.copyClient = app.getSVNClientManager().getCopyClient();
        this.copyClient.setCommitHandler(new ISVNCommitHandler(){

            public String getCommitMessage(String message, SVNCommitItem[] commitables) throws SVNException {
                return message;
            }

            public SVNProperties getRevisionProperties(String message, SVNCommitItem[] commitables, SVNProperties revisionProperties) throws SVNException {
                return revisionProperties;
            }
        });
        this.updateClient = app.getSVNClientManager().getUpdateClient();
        this.updateClient.setEventHandler(new ISVNEventHandler(){

            public void handleEvent(SVNEvent event, double progress) throws SVNException {
                if (event.getFile() != null) {
                    BranchTask.this.setMessage(event.getFile().toString());
                } else {
                    System.out.println("getFile() returned null!");
                }
            }

            public void checkCancelled() throws SVNCancelException {
            }
        });
    }

    protected Void doInBackground() throws Exception {
        SVNCopySource[] sources = new SVNCopySource[]{new SVNCopySource(SVNRevision.HEAD, SVNRevision.BASE, this.source)};
        this.setMessage("Creating Branch " + this.destination);
        String message = null;
        SVNInfo info = SVNApp.getApplication().getFileInfo(this.source);
        if (info != null) {
            message = "Working copy branch from " + info.getURL().toString() + "@" + info.getRevision().getNumber();
        }
        this.copyClient.doCopy(sources, this.destination, false, false, true, "Working copy branch from " + this.app.getRootURL(this.source), null);
        this.setMessage("Switching to Branch " + this.destination);
        this.switchRevisionNumber = this.updateClient.doSwitch(this.source, this.destination, SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.UNKNOWN, false, false);
        return null;
    }

    protected void succeeded(Void result) {
        this.firePropertyChange("refresh", null, "Branch Succeded. Updated to revision " + this.switchRevisionNumber);
    }

    protected void finished() {
        if (this.isCancelled()) {
            this.firePropertyChange("refresh", null, "Branch Canceled.");
        }
    }

    protected void failed(Throwable cause) {
        this.firePropertyChange("refresh", null, "Branch Failed: " + cause.getMessage());
        Logger.getLogger(BranchTask.class.getName()).log(Level.WARNING, null, cause);
    }
}

