/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.tasks;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.application.Application;
import org.jdesktop.application.Task;
import org.sdrinovsky.sdsvn.SVNApp;
import org.sdrinovsky.sdsvn.tasks.CheckoutTask;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class AddTask
extends Task<Void, Void> {
    List<File> files;
    SVNWCClient wcClient;
    SVNApp app;

    public AddTask(SVNApp app, List<File> files) {
        super((Application)app);
        this.files = files;
        this.app = app;
        this.wcClient = app.getSVNClientManager().getWCClient();
    }

    protected Void doInBackground() throws Exception {
        int counter = 0;
        int total = this.files.size();
        for (File file : this.files) {
            if (++counter <= total) {
                this.setProgress((float)counter / (float)total);
            }
            this.wcClient.doAdd(file, false, false, true, SVNDepth.INFINITY, true, false);
        }
        return null;
    }

    protected void failed(Throwable cause) {
        this.setMessage("Add failed. " + cause.getMessage());
        Logger.getLogger(CheckoutTask.class.getName()).log(Level.WARNING, null, cause);
    }

    protected void succeeded(Void info) {
        this.firePropertyChange("refresh", null, "Files have been scheduled for Add.");
    }
}

