/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.properties;

import java.awt.Component;
import javax.swing.JComboBox;
import org.jdesktop.application.SessionStorage;

public class ComboBoxProperty
implements SessionStorage.Property {
    private void checkComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (!(component instanceof JComboBox)) {
            throw new IllegalArgumentException("invalid component");
        }
    }

    public Object getSessionState(Component c) {
        this.checkComponent(c);
        String[] items = new String[((JComboBox)c).getItemCount()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = ((JComboBox)c).getItemAt(i).toString();
        }
        return new ComboBoxState(items);
    }

    public void setSessionState(Component c, Object state) {
        this.checkComponent(c);
        String[] items = ((ComboBoxState)state).getItems();
        for (int i = 0; i < items.length; ++i) {
            ((JComboBox)c).addItem(items[i]);
        }
    }

    public static class ComboBoxState {
        public String[] items = new String[0];

        public ComboBoxState() {
        }

        public ComboBoxState(String[] state) {
            this.copyState(state);
        }

        public void setItems(String[] state) {
            this.copyState(state);
        }

        public String[] getItems() {
            return this.items;
        }

        private void copyState(String[] state) {
            this.items = new String[state.length];
            System.arraycopy(state, 0, this.items, 0, state.length);
        }
    }
}

