/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.graph;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.widget.Scene;

public class SceneSupport {
    public static void show(final Scene scene) {
        if (SwingUtilities.isEventDispatchThread()) {
            SceneSupport.showEDT(scene);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SceneSupport.showEDT(scene);
                }
            });
        }
    }

    private static void showEDT(Scene scene) {
        JComponent sceneView = scene.getView();
        if (sceneView == null) {
            sceneView = scene.createView();
        }
        SceneSupport.show(sceneView);
    }

    public static void show(final JComponent sceneView) {
        if (SwingUtilities.isEventDispatchThread()) {
            SceneSupport.showEDT(sceneView);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SceneSupport.showEDT(sceneView);
                }
            });
        }
    }

    private static void showEDT(JComponent sceneView) {
        JScrollPane panel = new JScrollPane(sceneView);
        panel.getHorizontalScrollBar().setUnitIncrement(32);
        panel.getHorizontalScrollBar().setBlockIncrement(256);
        panel.getVerticalScrollBar().setUnitIncrement(32);
        panel.getVerticalScrollBar().setBlockIncrement(256);
        SceneSupport.showCoreEDT(panel);
    }

    public static void showCore(final JComponent view) {
        if (SwingUtilities.isEventDispatchThread()) {
            SceneSupport.showCoreEDT(view);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SceneSupport.showCoreEDT(view);
                }
            });
        }
    }

    private static void showCoreEDT(JComponent view) {
        int width = 800;
        int height = 600;
        JFrame frame = new JFrame();
        frame.add((Component)view, "Center");
        frame.setDefaultCloseOperation(2);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setBounds((screenSize.width - width) / 2, (screenSize.height - height) / 2, width, height);
        frame.setVisible(true);
    }

    public static int randInt(int max) {
        return (int)(Math.random() * (double)max);
    }

    public static void sleep(int delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

