/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.SelectProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Widget;
import org.sdrinovsky.sdsvn.SVNApp;
import org.sdrinovsky.sdsvn.files.FileTableRow;
import org.sdrinovsky.sdsvn.files.Location;
import org.sdrinovsky.sdsvn.graph.GraphLogEntry;
import org.sdrinovsky.sdsvn.graph.GraphTree;
import org.sdrinovsky.sdsvn.graph.GraphTreeWidget;
import org.sdrinovsky.sdsvn.graph.RevisionGraphScene;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class RevisionGraph {
    RevisionGraphScene scene;
    JTextArea messagePane;
    List<GraphTreeWidget> selected = new LinkedList<GraphTreeWidget>();
    FileTableRow row = null;
    boolean controlDown = false;
    Action compareWCAction = new AbstractAction("Compare to wc"){

        @Override
        public boolean isEnabled() {
            return RevisionGraph.this.selected.size() == 1;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String diffProgram = SVNApp.getApplication().getPreferences().get("diffProgram", null);
                GraphLogEntry entry1 = RevisionGraph.this.selected.get(0).getEntry().getLogEntry();
                SVNURL url1 = SVNURL.parseURIDecoded((String)entry1.getURL());
                File svn1 = File.createTempFile("svndiff", ".r" + entry1.getRevision());
                svn1.delete();
                System.out.println("getting " + url1 + "@" + entry1.getRevision());
                SVNApp.getApplication().getSVNClientManager().getUpdateClient().doExport(url1, svn1, SVNRevision.UNDEFINED, SVNRevision.create((long)entry1.getRevision()), null, false, SVNDepth.INFINITY);
                svn1.deleteOnExit();
                svn1.setReadOnly();
                Runtime.getRuntime().exec(new String[]{diffProgram, svn1.getPath(), RevisionGraph.this.row.getFile().toString()});
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    };
    Action compareAction = new AbstractAction("Compare"){

        @Override
        public boolean isEnabled() {
            return RevisionGraph.this.selected.size() == 2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Collections.sort(RevisionGraph.this.selected);
                String diffProgram = SVNApp.getApplication().getPreferences().get("diffProgram", null);
                GraphLogEntry entry1 = RevisionGraph.this.selected.get(0).getEntry().getLogEntry();
                GraphLogEntry entry2 = RevisionGraph.this.selected.get(1).getEntry().getLogEntry();
                SVNURL url1 = SVNURL.parseURIDecoded((String)entry1.getURL());
                SVNURL url2 = SVNURL.parseURIDecoded((String)entry2.getURL());
                File svn1 = File.createTempFile("svndiff", ".r" + entry1.getRevision());
                File svn2 = File.createTempFile("svndiff", ".r" + entry2.getRevision());
                svn1.delete();
                svn2.delete();
                System.out.println("getting " + url1 + "@" + entry1.getRevision());
                SVNApp.getApplication().getSVNClientManager().getUpdateClient().doExport(url1, svn1, SVNRevision.UNDEFINED, SVNRevision.create((long)entry1.getRevision()), null, false, SVNDepth.INFINITY);
                svn1.deleteOnExit();
                System.out.println("getting " + url2 + "@" + entry2.getRevision());
                SVNApp.getApplication().getSVNClientManager().getUpdateClient().doExport(url2, svn2, SVNRevision.UNDEFINED, SVNRevision.create((long)entry2.getRevision()), null, false, SVNDepth.INFINITY);
                svn2.deleteOnExit();
                svn1.setReadOnly();
                svn2.setReadOnly();
                Runtime.getRuntime().exec(new String[]{diffProgram, svn1.getPath(), svn2.getPath()});
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    };
    private WidgetAction popupMenuAction = ActionFactory.createPopupMenuAction((PopupMenuProvider)new PopupMenuProvider(){

        public JPopupMenu getPopupMenu(Widget widget, Point localLocation) {
            JPopupMenu menu = new JPopupMenu();
            JMenuItem compareMenuItem = new JMenuItem(RevisionGraph.this.compareAction);
            JMenuItem compareWCMenuItem = new JMenuItem(RevisionGraph.this.compareWCAction);
            menu.add(compareMenuItem);
            menu.add(compareWCMenuItem);
            return menu;
        }
    });
    private WidgetAction selectAction = ActionFactory.createSelectAction((SelectProvider)new SelectProvider(){
        ObjectState normalState = ObjectState.createNormal();
        ObjectState selectedState = ObjectState.createNormal().deriveSelected(true);

        public boolean isAimingAllowed(Widget widget, Point localLocation, boolean invertSelection) {
            return true;
        }

        public boolean isSelectionAllowed(Widget widget, Point localLocation, boolean invertSelection) {
            return true;
        }

        public void select(Widget widget, Point localLocation, boolean invertSelection) {
            GraphTreeWidget graphTreeWidget = (GraphTreeWidget)widget;
            if (!graphTreeWidget.getEntry().isLabel()) {
                if (!RevisionGraph.this.controlDown) {
                    for (GraphTreeWidget w : RevisionGraph.this.selected) {
                        w.setState(this.normalState);
                    }
                    RevisionGraph.this.selected.clear();
                }
                if (!RevisionGraph.this.selected.contains(graphTreeWidget)) {
                    RevisionGraph.this.selected.add(graphTreeWidget);
                }
                graphTreeWidget.setState(this.selectedState);
                GraphLogEntry log = graphTreeWidget.getEntry().getLogEntry();
                if (log != null) {
                    RevisionGraph.this.messagePane.append("------------------------\n");
                    RevisionGraph.this.messagePane.append("Revision: " + log.getRevision() + "\n");
                    RevisionGraph.this.messagePane.append("Date: " + log.getDate() + "\n");
                    RevisionGraph.this.messagePane.append("Auther: " + log.getAuthor() + "\n");
                    RevisionGraph.this.messagePane.append("Description:\n" + log.getMessage() + "\n");
                    RevisionGraph.this.messagePane.append("Changed Paths:\n");
                    for (Object key : log.getChangedPaths().values()) {
                        RevisionGraph.this.messagePane.append("  " + key + "\n");
                    }
                    RevisionGraph.this.messagePane.setCaretPosition(RevisionGraph.this.messagePane.getDocument().getLength());
                }
            }
        }
    });
    private int globalIndex = 0;

    public RevisionGraph(FileTableRow row, Location location) {
        this.scene = new RevisionGraphScene();
        this.scene.getActions().addAction(ActionFactory.createPanAction());
        this.row = row;
    }

    public void setMesagePane(JTextArea textArea) {
        this.messagePane = textArea;
    }

    public void setZoom(double d) {
        this.scene.setZoomFactor(d);
        this.scene.validate();
    }

    public double getZomm() {
        return this.scene.getZoomFactor();
    }

    public void showScene(GraphTree tree) {
        JFrame frame = new JFrame(this.row.getFileName() + ":" + this.row.getRevision());
        int width = 800;
        int height = 600;
        int satelliteHeight = 100;
        if (this.messagePane == null) {
            JSplitPane splitPane = new JSplitPane(0);
            splitPane.setLeftComponent(new JScrollPane(this.buildScene(tree)));
            this.messagePane = new JTextArea();
            this.messagePane.setRows(12);
            this.messagePane.setLineWrap(true);
            splitPane.setRightComponent(new JScrollPane(this.messagePane));
            splitPane.setDividerLocation(0.65);
            frame.getContentPane().add((Component)splitPane, "Center");
        } else {
            frame.getContentPane().add((Component)new JScrollPane(this.buildScene(tree)), "Center");
        }
        frame.setDefaultCloseOperation(2);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setBounds((screenSize.width - width) / 2, (screenSize.height - height) / 2, width, height);
        frame.setVisible(true);
        JFrame satelliteView = new JFrame();
        satelliteView.getContentPane().add((Component)this.getSatelliteView(), "Center");
        satelliteView.setBounds((screenSize.width - width) / 2, (screenSize.height - height) / 2 - satelliteHeight, width, satelliteHeight);
        satelliteView.setDefaultCloseOperation(2);
        satelliteView.setVisible(true);
    }

    public JComponent buildScene(GraphTree tree) {
        this.buildScene(this.scene, null, 0, tree);
        final JComponent component = this.scene.createView();
        component.setFocusable(true);
        component.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                component.getParent().dispatchEvent(e);
            }
        });
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                component.grabFocus();
            }
        });
        component.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!RevisionGraph.this.controlDown && e.isControlDown()) {
                    RevisionGraph.this.controlDown = true;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                RevisionGraph.this.controlDown = false;
            }
        });
        return component;
    }

    public JComponent getSatelliteView() {
        return this.scene.createSatelliteView();
    }

    public void buildScene(RevisionGraphScene scene, GraphTreeWidget parent, int index, GraphTree tree) {
        GraphTreeWidget w = this.addNode(scene, tree, parent, index);
        int localIndex = 0;
        for (GraphTree node : tree) {
            if (node.isLabel()) {
                ++localIndex;
            }
            this.buildScene(scene, w, localIndex, node);
        }
    }

    public GraphTreeWidget addNode(RevisionGraphScene scene, GraphTree node, GraphTreeWidget parent, int branch) {
        GraphTreeWidget w = (GraphTreeWidget)scene.addNode(node);
        Point location = null;
        if (parent != null) {
            scene.addEdge(w.getLabel() + "edge");
            scene.setEdgeSource(w.getLabel() + "edge", parent.getEntry());
            scene.setEdgeTarget(w.getLabel() + "edge", node);
            int x = parent.getPreferredLocation().x;
            int y = parent.getPreferredLocation().y;
            if (branch > 0) {
                if (this.globalIndex == 0) {
                    y += 60;
                } else {
                    x += 250 * this.globalIndex;
                }
                ++this.globalIndex;
            } else {
                y += 60;
            }
            location = new Point(x, y);
        } else {
            location = new Point(25, 50);
        }
        w.setPreferredLocation(location);
        w.getActions().addAction(this.selectAction);
        w.getActions().addAction(this.popupMenuAction);
        if (!node.isLabel()) {
            GraphLogEntry entry = node.getLogEntry();
            if (entry.getRevision() == this.row.getCommitRevision() || node.isLeaf() && entry.getRevision() == this.row.getCommitRevision()) {
                if (this.row.isCommitable()) {
                    w.setForeground(Color.red);
                } else {
                    w.setForeground(Color.blue);
                }
            }
            w.setToolTipText(entry.getDate() + " : " + entry.getAuthor() + " : " + entry.getMessage());
        }
        return w;
    }
}

