/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.graph;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.sdrinovsky.sdsvn.SVNApp;
import org.sdrinovsky.sdsvn.files.FileTableRow;
import org.sdrinovsky.sdsvn.files.Location;
import org.sdrinovsky.sdsvn.graph.GraphTree;
import org.sdrinovsky.sdsvn.graph.RevisionGraph;

public class GraphView
extends JFrame {
    private RevisionGraph graph;
    private JFrame satelliteView = new JFrame();
    private JScrollPane scroll;
    private boolean wasSatelliteViewShown = false;
    private JComboBox jComboBox1;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JTextArea jTextArea1;
    private JToggleButton jToggleButton1;
    private JToolBar jToolBar1;

    public GraphView(FileTableRow row, Location location, GraphTree root) {
        this.initComponents();
        this.graph = new RevisionGraph(row, location);
        this.graph.setMesagePane(this.jTextArea1);
        JComponent scene = this.graph.buildScene(root);
        this.scroll = new JScrollPane(scene);
        this.scroll.getVerticalScrollBar().setUnitIncrement(60);
        this.scroll.getVerticalScrollBar().setBlockIncrement(60);
        this.jSplitPane1.setTopComponent(this.scroll);
        this.satelliteView.getContentPane().add((Component)this.graph.getSatelliteView(), "Center");
        this.satelliteView.setDefaultCloseOperation(1);
        this.satelliteView.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                super.componentHidden(e);
                GraphView.this.jToggleButton1.setSelected(false);
            }
        });
    }

    @Override
    public void dispose() {
        this.satelliteView.dispose();
        super.dispose();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jToolBar1 = new JToolBar();
        this.jToggleButton1 = new JToggleButton();
        this.jComboBox1 = new JComboBox();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = ((SVNApp)Application.getInstance(SVNApp.class)).getContext().getResourceMap(GraphView.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.jSplitPane1.setDividerLocation(350);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jSplitPane1.setName("jSplitPane1");
        this.jScrollPane1.setName("jScrollPane1");
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setName("jTextArea1");
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jSplitPane1.setBottomComponent(this.jScrollPane1);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setName("jToolBar1");
        ApplicationActionMap actionMap = ((SVNApp)Application.getInstance(SVNApp.class)).getContext().getActionMap(GraphView.class, (Object)this);
        this.jToggleButton1.setAction(actionMap.get("satelliteView"));
        this.jToggleButton1.setFocusable(false);
        this.jToggleButton1.setHorizontalTextPosition(0);
        this.jToggleButton1.setName("jToggleButton1");
        this.jToggleButton1.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jToggleButton1);
        this.jComboBox1.setEditable(true);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"400%", "200%", "100%", "50%", "10%", "5%"}));
        this.jComboBox1.setSelectedItem("100%");
        this.jComboBox1.setMaximumSize(new Dimension(70, Short.MAX_VALUE));
        this.jComboBox1.setName("jComboBox1");
        this.jComboBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GraphView.this.jComboBox1ItemStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.jComboBox1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, 509, Short.MAX_VALUE).addComponent(this.jSplitPane1, -1, 509, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 523, Short.MAX_VALUE)));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 517) / 2, (screenSize.height - 588) / 2, 517, 588);
    }

    private void jComboBox1ItemStateChanged(ItemEvent evt) {
        this.updateZoom();
    }

    public void updateZoom() {
        String zoomString = this.jComboBox1.getSelectedItem().toString();
        if (zoomString.charAt(zoomString.length() - 1) == '%') {
            zoomString = zoomString.substring(0, zoomString.length() - 1);
        }
        double zoomFactor = Double.parseDouble(zoomString) / 100.0;
        this.scroll.getVerticalScrollBar().setUnitIncrement((int)(60.0 * zoomFactor));
        this.scroll.getVerticalScrollBar().setBlockIncrement((int)(60.0 * zoomFactor));
        this.graph.setZoom(zoomFactor);
    }

    @Action
    public void satelliteView() {
        if (this.jToggleButton1.isSelected()) {
            if (!this.wasSatelliteViewShown) {
                this.wasSatelliteViewShown = true;
                int y = this.getY() - 200;
                if (y < 0) {
                    y = 0;
                }
                this.satelliteView.setBounds(this.getX(), y, this.getWidth(), 200);
            }
            this.satelliteView.setVisible(true);
        } else {
            this.satelliteView.setVisible(false);
        }
    }
}

