/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.graph;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.sdrinovsky.sdsvn.graph.GraphTree;

public class GraphTreeWidget
extends LabelWidget
implements Comparable<GraphTreeWidget> {
    private static final Border NORMAL_BORDER;
    private static final Border SELECTED_BORDER;
    private static final Color NORMAL_COLOR;
    private static final Color SELECTED_COLOR;
    private GraphTree entry;
    private WidgetAction moveAction = ActionFactory.createMoveAction();
    private Rectangle size = new Rectangle(0, -17, 200, 21);

    private static String getGraphTreeLabel(GraphTree entry) {
        if (entry == null) {
            return null;
        }
        if (entry.isLabel()) {
            return entry.getLabel();
        }
        return Long.toString(entry.getLogEntry().getRevision());
    }

    public GraphTreeWidget(Scene scene) {
        this(scene, null);
    }

    public GraphTreeWidget(Scene scene, GraphTree entry) {
        super(scene, GraphTreeWidget.getGraphTreeLabel(entry));
        this.entry = entry;
    }

    public GraphTree getEntry() {
        return this.entry;
    }

    public void setEntry(GraphTree entry) {
        this.entry = entry;
        this.setLabel(GraphTreeWidget.getGraphTreeLabel(entry));
    }

    public void notifyStateChanged(ObjectState oldState, ObjectState newState) {
        if (newState.isSelected()) {
            this.setBorder(SELECTED_BORDER);
            this.setBackground(SELECTED_COLOR);
        } else {
            this.setBorder(NORMAL_BORDER);
            this.setBackground(NORMAL_COLOR);
        }
    }

    protected Rectangle calculateClientArea() {
        return this.size;
    }

    protected void paintWidget() {
        int y;
        int x;
        if (this.getLabel() == null) {
            return;
        }
        Graphics2D gr = this.getGraphics();
        gr.setFont(this.getFont());
        FontMetrics fontMetrics = gr.getFontMetrics();
        Rectangle clientArea = this.getClientArea();
        Rectangle bounds = this.getBounds();
        switch (this.getAlignment()) {
            case BASELINE: {
                x = 0;
                break;
            }
            case LEFT: {
                x = clientArea.x;
                break;
            }
            case CENTER: {
                x = clientArea.x + (clientArea.width - fontMetrics.stringWidth(this.getLabel())) / 2;
                break;
            }
            case RIGHT: {
                x = clientArea.x + clientArea.width - fontMetrics.stringWidth(this.getLabel());
                break;
            }
            default: {
                return;
            }
        }
        switch (this.getVerticalAlignment()) {
            case BASELINE: {
                y = 0;
                break;
            }
            case TOP: {
                y = clientArea.y + fontMetrics.getAscent();
                break;
            }
            case CENTER: {
                y = clientArea.y + (clientArea.height + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
                break;
            }
            case BOTTOM: {
                y = clientArea.y + fontMetrics.getAscent() + clientArea.height - fontMetrics.getDescent();
                break;
            }
            default: {
                return;
            }
        }
        Paint background = this.getBackground();
        Color bgColor = null;
        if (background instanceof Color) {
            bgColor = (Color)background;
        }
        if (this.isPaintAsDisabled() && bgColor != null) {
            gr.setColor(bgColor.brighter());
            gr.drawString(this.getLabel(), x + 1, y + 1);
            gr.setColor(bgColor.darker());
            gr.drawString(this.getLabel(), x, y);
        } else {
            if (bgColor != null) {
                gr.setColor(bgColor);
                gr.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            }
            gr.setColor(this.getForeground());
            gr.drawString(this.getLabel(), x, y);
        }
    }

    @Override
    public int compareTo(GraphTreeWidget o) {
        return this.entry.compareTo(o.entry);
    }

    static {
        SELECTED_BORDER = NORMAL_BORDER = new Border(){

            public Insets getInsets() {
                return new Insets(1, 1, 4, 4);
            }

            public void paint(Graphics2D g, Rectangle bounds) {
                int x = bounds.x;
                int y = bounds.y;
                int width = bounds.width;
                int height = bounds.height;
                g.setColor(Color.GRAY);
                g.fillRect(x + 4, y + 4, width, height);
                g.setColor(Color.BLACK);
                g.fillRect(x, y, width - 3, height - 3);
            }

            public boolean isOpaque() {
                return true;
            }
        };
        NORMAL_COLOR = Color.WHITE;
        SELECTED_COLOR = new Color(212, 212, 255);
    }
}

