/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.graph;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.sdrinovsky.sdsvn.graph.GraphLogEntry;

public class GraphTree
implements Iterable<GraphTree>,
Comparable<GraphTree> {
    private List<GraphTree> subtree = new LinkedList<GraphTree>();
    private GraphLogEntry logEntry;
    private String label;

    public GraphTree() {
        this.logEntry = null;
    }

    public GraphTree(GraphLogEntry logEntry) {
        this.logEntry = logEntry;
    }

    public GraphTree(String label) {
        this.label = label;
    }

    public GraphTree(String label, GraphTree subtree) {
        this.label = label;
        this.add(subtree);
    }

    public GraphTree(GraphLogEntry logEntry, GraphTree subtree) {
        this.logEntry = logEntry;
        this.add(subtree);
    }

    public GraphTree(GraphLogEntry logEntry, List<GraphTree> subtree) {
        this.logEntry = logEntry;
        for (GraphTree tree : subtree) {
            this.add(tree);
        }
    }

    public void setLogEntry(GraphLogEntry logEntry) {
        this.logEntry = logEntry;
    }

    public GraphTree add(GraphLogEntry logEntry) {
        return this.add(new GraphTree(logEntry));
    }

    public GraphTree add(GraphTree tree) {
        if (tree.isLabel() && !tree.isLeaf()) {
            long revision = tree.getChildAt(0).getLogEntry().getRevision();
            GraphTree match = this.findMatchingRevision(revision);
            if (match != null) {
                GraphTree pop = tree.subtree.remove(0).getChildAt(0);
                if (pop != null) {
                    tree.subtree.add(0, pop);
                }
                match.subtree.add(tree);
            } else {
                this.subtree.add(tree);
            }
        } else {
            this.subtree.add(tree);
        }
        return tree;
    }

    public boolean isLeaf() {
        return this.subtree.size() == 0;
    }

    public boolean isLabel() {
        return this.label != null;
    }

    public int getNumberChildren() {
        return this.subtree.size();
    }

    public GraphTree getChildAt(int index) {
        if (index >= 0 && index < this.subtree.size()) {
            return this.subtree.get(index);
        }
        return null;
    }

    @Override
    public Iterator<GraphTree> iterator() {
        return this.subtree.iterator();
    }

    public String getLabel() {
        return this.label;
    }

    public GraphLogEntry getLogEntry() {
        return this.logEntry;
    }

    private GraphTree findMatchingRevision(long revision) {
        for (GraphTree tree : this.subtree) {
            if (!tree.isLabel() && tree.getLogEntry().getRevision() == revision) {
                return tree;
            }
            GraphTree found = tree.findMatchingRevision(revision);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public String toString() {
        String ret = "";
        ret = this.isLabel() ? ret + this.label : ret + this.logEntry.getRevision();
        if (!this.isLeaf()) {
            boolean start = true;
            for (GraphTree tree : this.subtree) {
                ret = start ? ret + ": " : ret + ", ";
                start = false;
                ret = ret + tree;
            }
            return ret;
        }
        return ret;
    }

    @Override
    public int compareTo(GraphTree o) {
        if (this.isLabel()) {
            if (o.isLabel()) {
                return this.label.compareTo(o.label);
            }
            return 1;
        }
        if (o.isLabel()) {
            return -1;
        }
        return (int)(this.logEntry.getRevision() - o.logEntry.getRevision());
    }
}

