/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.files;

import java.io.File;
import org.sdrinovsky.sdsvn.files.FileTableRow;

public class Location {
    private final String server;
    private final String branch;
    private final String path;
    private final File workingCopyBase;

    public Location(File file, String url) {
        this(file, FileTableRow.parseURL(url, 0), FileTableRow.parseURL(url, 1), FileTableRow.parseURL(url, 2));
    }

    public Location(File file, String server, String branch, String path) {
        this.server = server;
        this.branch = branch;
        this.path = path;
        String tmpwc = file.toString().replace('\\', '/');
        this.workingCopyBase = tmpwc.length() > path.length() + 1 ? new File(tmpwc.substring(0, tmpwc.length() - path.length())) : null;
    }

    public String getServer() {
        return this.server;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getPath() {
        return this.path;
    }

    public String getURL() {
        return this.server + "/" + this.branch + "/" + this.path;
    }

    public String getURL(String newPath) {
        return this.server + "/" + this.branch + "/" + newPath;
    }

    public File getWorkingCopyBase() {
        return this.workingCopyBase;
    }

    public String toString() {
        return this.branch;
    }
}

