/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.files;

import java.io.File;
import java.util.Date;
import org.sdrinovsky.sdsvn.files.FileRow;
import org.sdrinovsky.sdsvn.files.Location;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class FileTableRow
implements FileRow {
    public static final int STATUS_COLUMN = 0;
    public static final int FILE_COLUMN = 1;
    public static final int EXT_COLUMN = 2;
    public static final int FOLDER_COLUMN = 3;
    public static final int COMMITTED_REVISION_COLUMN = 4;
    public static final int REVISION_COLUMN = 5;
    public static final int MODIFIED_COLUMN = 6;
    public static final int URL_COLUMN = 7;
    private static String[] columnNames = new String[]{"Status", "Name", "Ext", "Folder", "Committed Revision", "Revision", "Modified", "Location"};
    private static Class[] columnClass = new Class[]{String.class, String.class, String.class, File.class, Long.class, Long.class, Date.class, String.class};
    private static int[] columnWidths = new int[]{65, 256, 85, 512, 85, 85, 185, 175};
    public static final int PARSE_URL_SERVER = 0;
    public static final int PARSE_URL_BRANCH = 1;
    public static final int PARSE_URL_PATH = 2;
    private final String status;
    private final File folder;
    private final String file;
    private final String ext;
    private final long revision;
    private final long committedRevision;
    private final Date modified;
    private final Location location;

    public static int getColumnCount() {
        return columnNames.length;
    }

    public static String getColumnName(int column) {
        return columnNames[column];
    }

    public static Class<?> getColumnClass(int column) {
        return columnClass[column];
    }

    public static int getColumnWidth(int column) {
        return columnWidths[column];
    }

    public static char[] getStatus(SVNStatus status) {
        char[] s = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' '};
        s[0] = status.getContentsStatus().getCode();
        s[1] = status.getPropertiesStatus().getCode();
        if (status.isLocked()) {
            s[2] = 76;
        }
        if (status.isCopied()) {
            s[3] = 43;
        }
        if (status.isSwitched()) {
            s[4] = 83;
        }
        if (status.getLocalLock() != null) {
            s[5] = 75;
        }
        if (status.getRemotePropertiesStatus() != SVNStatusType.STATUS_NONE || status.getRemoteContentsStatus() != SVNStatusType.STATUS_NONE) {
            s[6] = 42;
        }
        return s;
    }

    public static boolean isModified(String status) {
        if (status != null && status.length() > 0) {
            switch (status.charAt(0)) {
                case 'C': 
                case 'M': {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isConflicted(String status) {
        return status != null && status.length() > 0 && status.charAt(0) == 'C';
    }

    public static boolean isPropertyModified(String status) {
        return status != null && status.length() > 1 && status.charAt(1) == 'M';
    }

    public static String parseURL(String url, int type) {
        String branches = "/branches/";
        String tags = "/tags/";
        String trunk = "/trunk";
        int index = url.indexOf(branches);
        if (index >= 0) {
            int index2 = url.indexOf("/", index + branches.length() + 1);
            if (index2 > 0) {
                switch (type) {
                    case 0: {
                        return url.substring(0, index);
                    }
                    case 1: {
                        return url.substring(index + 1, index2);
                    }
                    case 2: {
                        return url.substring(index2 + 1);
                    }
                }
                return url;
            }
            switch (type) {
                case 0: {
                    return url.substring(0, index);
                }
                case 1: {
                    return url.substring(index + 1);
                }
                case 2: {
                    return "";
                }
            }
            return url;
        }
        index = url.indexOf(tags);
        if (index >= 0) {
            int index2 = url.indexOf("/", index + tags.length() + 1);
            if (index2 > 0) {
                switch (type) {
                    case 0: {
                        return url.substring(0, index);
                    }
                    case 1: {
                        return url.substring(index + 1, index2);
                    }
                    case 2: {
                        return url.substring(index2 + 1);
                    }
                }
                return url;
            }
            switch (type) {
                case 0: {
                    return url.substring(0, index);
                }
                case 1: {
                    return url.substring(index + 1);
                }
                case 2: {
                    return "";
                }
            }
            return url;
        }
        index = url.indexOf(trunk);
        if (index >= 0) {
            switch (type) {
                case 0: {
                    return url.substring(0, index);
                }
                case 1: {
                    return "trunk";
                }
                case 2: {
                    if (url.length() >= index + 1 + trunk.length()) {
                        return url.substring(index + 1 + trunk.length());
                    }
                    return "";
                }
            }
            return url;
        }
        return url;
    }

    public static String switchBranch(String url, String branch) {
        String server = FileTableRow.parseURL(url, 0);
        String path = FileTableRow.parseURL(url, 2);
        return server + "/" + branch + "/" + path;
    }

    public FileTableRow(SVNStatus status) {
        File statusFile = status.getFile();
        this.status = new String(FileTableRow.getStatus(status));
        this.folder = statusFile.getParentFile();
        this.file = statusFile.getName();
        this.revision = status.getRevision().getNumber();
        this.committedRevision = status.getCommittedRevision().getNumber();
        int extIndex = this.file.lastIndexOf(46);
        this.ext = statusFile.isFile() && extIndex > 0 ? this.file.substring(extIndex + 1) : "";
        long lastModified = statusFile.lastModified();
        this.modified = lastModified > 0L ? new Date(lastModified) : null;
        this.location = status.getURL() != null ? new Location(statusFile, status.getURL().toString()) : null;
    }

    public Object get(int index) {
        switch (index) {
            case 0: {
                return this.status;
            }
            case 3: {
                return this.folder;
            }
            case 1: {
                return this.file;
            }
            case 2: {
                return this.ext;
            }
            case 6: {
                return this.modified;
            }
            case 4: {
                return this.committedRevision;
            }
            case 5: {
                return this.revision;
            }
            case 7: {
                if (this.location != null) {
                    return this.location.getBranch();
                }
                return "";
            }
        }
        return null;
    }

    public boolean isCommitable() {
        boolean fileModified = this.status.charAt(0) == 'A' || this.status.charAt(0) == 'R' || this.status.charAt(0) == '~' || this.status.charAt(0) == 'D' || this.status.charAt(0) == 'M' || this.status.charAt(0) == 'C';
        boolean folderModified = this.status.charAt(1) == 'C' || this.status.charAt(1) == 'M';
        return fileModified || folderModified;
    }

    public boolean isConflict() {
        boolean fileModified = this.status.charAt(0) == 'C';
        boolean folderModified = this.status.charAt(1) == 'C';
        return fileModified || folderModified;
    }

    public boolean isAddable() {
        return this.status.charAt(0) == '?';
    }

    public boolean isIgnored() {
        return this.status.charAt(0) == 'I';
    }

    public boolean isMissing() {
        return this.status.charAt(0) == '!';
    }

    public boolean needsUpdate() {
        return this.status.charAt(6) == '*';
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public File getFolder() {
        return this.folder;
    }

    @Override
    public File getFile() {
        return new File(this.folder, this.file);
    }

    public String getFileName() {
        return this.file;
    }

    public String getExt() {
        return this.ext;
    }

    public long getRevision() {
        return this.revision;
    }

    public long getCommitRevision() {
        return this.committedRevision;
    }

    public Date getModified() {
        return this.modified;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public String toString() {
        return this.getFile().toString();
    }
}

