/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.files;

import java.awt.Color;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.sdrinovsky.sdsvn.files.FileTableModel;

public class FileTableRenderer
extends DefaultTableCellRenderer {
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy KK:mm:ss a");
    private Color alternateColor = new Color(242, 242, 242);
    private Color red = new Color(255, 212, 212);
    private Color alternateRed = new Color(255, 200, 200);
    private Color blue = new Color(212, 212, 255);
    private Color alternateBlue = new Color(200, 200, 255);
    private Color green = new Color(212, 255, 212);
    private Color alternateGreen = new Color(200, 255, 200);
    private Color white = Color.white;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        FileTableModel model = (FileTableModel)table.getModel();
        if (value instanceof Date) {
            value = dateFormat.format((Date)value);
        }
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        int modelRow = table.getRowSorter().convertRowIndexToModel(row);
        if (!isSelected && !hasFocus) {
            if (row % 2 == 0) {
                if (model.getRow(modelRow).isCommitable()) {
                    comp.setBackground(this.alternateRed);
                } else if (model.getRow(modelRow).isIgnored()) {
                    comp.setBackground(this.alternateBlue);
                } else if (model.getRow(modelRow).needsUpdate()) {
                    comp.setBackground(this.alternateGreen);
                } else {
                    comp.setBackground(this.alternateColor);
                }
            } else if (model.getRow(modelRow).isCommitable()) {
                comp.setBackground(this.red);
            } else if (model.getRow(modelRow).isIgnored()) {
                comp.setBackground(this.blue);
            } else if (model.getRow(modelRow).needsUpdate()) {
                comp.setBackground(this.green);
            } else {
                comp.setBackground(this.white);
            }
        }
        return comp;
    }
}

