/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.files;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.sdrinovsky.sdsvn.files.FileRow;
import org.sdrinovsky.sdsvn.files.FileTableRow;
import org.sdrinovsky.sdsvn.files.Location;

public class FileRowImpl
implements FileRow {
    private File file;
    private Location location;

    public static List<FileRow> getList(File file, Location location) {
        return FileRowImpl.getList(new FileRowImpl(file, location));
    }

    public static List<FileRow> getList(FileRow file) {
        LinkedList<FileRow> list = new LinkedList<FileRow>();
        list.add(file);
        return list;
    }

    public static List<FileRow> getList(Set files, Location location) {
        LinkedList<FileRow> list = new LinkedList<FileRow>();
        for (Object object : files) {
            if (object instanceof FileRow) {
                list.add((FileRow)object);
                continue;
            }
            String path = FileTableRow.parseURL(object.toString(), 2);
            File file = new File(location.getWorkingCopyBase(), path);
            list.add(new FileRowImpl(file, new Location(file, location.getURL(path))));
        }
        return list;
    }

    public FileRowImpl(File file, Location location) {
        this.file = file;
        this.location = location;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public String getStatus() {
        return null;
    }
}

