/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.dialogs;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.sdrinovsky.sdsvn.SVNApp;

public class LoginDialog
extends JDialog {
    private JButton btnCancel;
    private JButton btnOk;
    private JLabel lblPassword;
    private JLabel lblUsername;
    private JPasswordField pfPassword;
    private JTextField tfUserName;

    public LoginDialog() {
        this(SVNApp.getApplication().getMainFrame());
    }

    public LoginDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.tfUserName.setText(SVNApp.getApplication().getPreferences().get("username", ""));
        this.pfPassword.setText(SVNApp.getApplication().getPreferences().get("password", ""));
    }

    private void initComponents() {
        this.lblUsername = new JLabel();
        this.tfUserName = new JTextField();
        this.lblPassword = new JLabel();
        this.pfPassword = new JPasswordField();
        this.btnCancel = new JButton();
        this.btnOk = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = ((SVNApp)Application.getInstance(SVNApp.class)).getContext().getResourceMap(LoginDialog.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setName("Form");
        this.setResizable(false);
        this.lblUsername.setDisplayedMnemonic('U');
        this.lblUsername.setHorizontalAlignment(4);
        this.lblUsername.setLabelFor(this.lblUsername);
        this.lblUsername.setText(resourceMap.getString("lblUsername.text", new Object[0]));
        this.lblUsername.setName("lblUsername");
        this.tfUserName.setText(resourceMap.getString("tfUserName.text", new Object[0]));
        this.tfUserName.setName("tfUserName");
        this.tfUserName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.accept(evt);
            }
        });
        this.lblPassword.setDisplayedMnemonic('P');
        this.lblPassword.setHorizontalAlignment(4);
        this.lblPassword.setLabelFor(this.pfPassword);
        this.lblPassword.setText(resourceMap.getString("lblPassword.text", new Object[0]));
        this.lblPassword.setName("lblPassword");
        this.pfPassword.setText(resourceMap.getString("pfPassword.text", new Object[0]));
        this.pfPassword.setName("pfPassword");
        this.pfPassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.accept(evt);
            }
        });
        this.btnCancel.setMnemonic('C');
        this.btnCancel.setText(resourceMap.getString("btnCancel.text", new Object[0]));
        this.btnCancel.setName("btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.btnOk.setMnemonic('O');
        this.btnOk.setText(resourceMap.getString("btnOk.text", new Object[0]));
        this.btnOk.setName("btnOk");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginDialog.this.accept(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblPassword, -1, -1, Short.MAX_VALUE).addComponent(this.lblUsername, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pfPassword, -1, 190, Short.MAX_VALUE).addComponent(this.tfUserName, -1, 190, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblUsername).addComponent(this.tfUserName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPassword).addComponent(this.pfPassword, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnOk)).addContainerGap()));
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void accept(ActionEvent evt) {
        String username = this.tfUserName.getText();
        String password = new String(this.pfPassword.getPassword());
        if (username == null || username.length() == 0) {
            SVNApp.getApplication().getPreferences().remove("username");
        } else {
            SVNApp.getApplication().getPreferences().put("username", username);
        }
        if (password == null || password.length() == 0) {
            SVNApp.getApplication().getPreferences().remove("password");
        } else {
            SVNApp.getApplication().getPreferences().put("password", password);
        }
        SVNApp.getApplication().resetSVNClientManager();
        this.dispose();
    }
}

