/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.dialogs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.jdesktop.application.Task;
import org.sdrinovsky.sdsvn.SVNApp;
import org.sdrinovsky.sdsvn.files.FileRowImpl;
import org.sdrinovsky.sdsvn.files.FileTableRow;
import org.sdrinovsky.sdsvn.files.Location;
import org.sdrinovsky.sdsvn.tasks.DiffTask;
import org.sdrinovsky.sdsvn.tasks.JIndentTask;
import org.sdrinovsky.sdsvn.tasks.MergeTask;
import org.sdrinovsky.sdsvn.tasks.UpdateTask;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class HistoryPopupMenu
extends JPopupMenu {
    public static final String DIFF_WC = "Diff File to WC";
    public static final String DIFF_PREVIOUS = "Show File Changes";
    public static final String DIFF_CS_WC = "Diff Changeset to WC";
    public static final String DIFF_CS_PREVIOUS = "Show Changeset Changes";
    public static final String UPDATE = "Update File to Revision";
    public static final String UPDATE_CS = "Update Changeset to Revision";
    public static final String REVERT = "Revert File Revision";
    public static final String REVERT_CS = "Revert Changeset Revision";
    public static final String JINDENT = "JIndent file";
    private SVNRevision revision;
    private Location location;
    private Set changedPaths;
    private Map<String, JMenuItem> items = new HashMap<String, JMenuItem>();

    public HistoryPopupMenu(boolean filesOnly, boolean diff, boolean update, boolean revert, boolean jindent) {
        this.init(filesOnly, diff, update, revert, jindent);
    }

    public void setRevision(SVNRevision rev) {
        this.revision = rev;
    }

    public void setRows(Location location, Set changedPaths) {
        block0: {
            Iterator i$;
            this.location = location;
            this.changedPaths = changedPaths;
            if (changedPaths.size() <= 0 || !(i$ = changedPaths.iterator()).hasNext()) break block0;
            Object path = i$.next();
            boolean enabled = location.getBranch().equals(FileTableRow.parseURL(path.toString(), 1));
            this.enableItems(enabled, UPDATE_CS, REVERT_CS);
        }
    }

    public void setRow(Location location, Object path) {
        this.location = location;
        this.changedPaths = new HashSet();
        this.changedPaths.add(path);
        this.enableItems(true, UPDATE, REVERT);
    }

    private void init(boolean filesOnly, boolean diff, boolean update, boolean revert, boolean jindent) {
        ActionListener menuListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Task task = null;
                if (HistoryPopupMenu.DIFF_WC.equals(event.getActionCommand()) || HistoryPopupMenu.DIFF_CS_WC.equals(event.getActionCommand())) {
                    task = new DiffTask(SVNApp.getApplication(), FileRowImpl.getList(HistoryPopupMenu.this.changedPaths, HistoryPopupMenu.this.location), HistoryPopupMenu.this.revision);
                } else if (HistoryPopupMenu.DIFF_PREVIOUS.equals(event.getActionCommand()) || HistoryPopupMenu.DIFF_CS_PREVIOUS.equals(event.getActionCommand())) {
                    task = new DiffTask(SVNApp.getApplication(), FileRowImpl.getList(HistoryPopupMenu.this.changedPaths, HistoryPopupMenu.this.location), SVNRevision.create((long)(HistoryPopupMenu.this.revision.getNumber() - 1L)), HistoryPopupMenu.this.revision);
                } else if (HistoryPopupMenu.UPDATE.equals(event.getActionCommand()) || HistoryPopupMenu.UPDATE_CS.equals(event.getActionCommand())) {
                    task = new UpdateTask(SVNApp.getApplication(), FileRowImpl.getList(HistoryPopupMenu.this.changedPaths, HistoryPopupMenu.this.location), HistoryPopupMenu.this.revision);
                } else if (HistoryPopupMenu.REVERT.equals(event.getActionCommand()) || HistoryPopupMenu.REVERT_CS.equals(event.getActionCommand())) {
                    task = new MergeTask(SVNApp.getApplication(), FileRowImpl.getList(HistoryPopupMenu.this.changedPaths, HistoryPopupMenu.this.location), HistoryPopupMenu.this.revision);
                } else if (HistoryPopupMenu.JINDENT.equals(event.getActionCommand())) {
                    LinkedList<FileTableRow> rows = new LinkedList<FileTableRow>();
                    for (Object o : HistoryPopupMenu.this.changedPaths) {
                        if (!(o instanceof FileTableRow)) continue;
                        rows.add((FileTableRow)o);
                    }
                    task = new JIndentTask(SVNApp.getApplication(), rows);
                }
                if (task != null) {
                    SVNApp.getApplication().executeTask(task);
                }
            }
        };
        if (jindent) {
            this.newMenuItem(JINDENT, menuListener);
        }
        if (filesOnly) {
            if (diff) {
                this.newMenuItem(DIFF_WC, menuListener);
                if (!jindent) {
                    this.newMenuItem(DIFF_PREVIOUS, menuListener);
                }
            }
            if (update) {
                this.newMenuItem(UPDATE, menuListener);
            }
            if (revert) {
                this.newMenuItem(REVERT, menuListener);
            }
        } else {
            if (diff) {
                this.newMenuItem(DIFF_CS_WC, menuListener);
                if (!jindent) {
                    this.newMenuItem(DIFF_CS_PREVIOUS, menuListener);
                }
            }
            if (update) {
                this.newMenuItem(UPDATE_CS, menuListener);
            }
            if (revert) {
                this.newMenuItem(REVERT_CS, menuListener);
            }
        }
    }

    private void enableItems(boolean enabled, String ... names) {
        for (String name : names) {
            JMenuItem item = this.items.get(name);
            if (item == null) continue;
            item.setEnabled(enabled);
        }
    }

    private void newMenuItem(String name, ActionListener listener) {
        JMenuItem item = this.add(name);
        item.addActionListener(listener);
        this.items.put(name, item);
    }
}

