/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.sdrinovsky.sdsvn.SVNApp;
import org.sdrinovsky.sdsvn.SortedListModel;
import org.sdrinovsky.sdsvn.dialogs.HistoryPopupMenu;
import org.sdrinovsky.sdsvn.files.Location;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;

public class HistoryDialog
extends JDialog {
    private long commitRevision = 0L;
    private boolean modified = false;
    private Location location;
    private HistoryPopupMenu changeSetPopupMenu;
    private HistoryPopupMenu filePopupMenu;
    private long minRevision;
    private long maxRevision;
    private Vector<SVNLogEntry> data = new Vector();
    private AbstractTableModel tableModel = new AbstractTableModel(){

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Revision";
                }
                case 1: {
                    return "Date";
                }
                case 2: {
                    return "Author";
                }
                case 3: {
                    return "Message";
                }
            }
            return "Unknown Column";
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return ((SVNLogEntry)HistoryDialog.this.data.get(row)).getRevision();
                }
                case 1: {
                    return ((SVNLogEntry)HistoryDialog.this.data.get(row)).getDate();
                }
                case 2: {
                    return ((SVNLogEntry)HistoryDialog.this.data.get(row)).getAuthor();
                }
                case 3: {
                    return ((SVNLogEntry)HistoryDialog.this.data.get(row)).getMessage();
                }
            }
            return "Unknown Column";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Long.class;
                }
                case 1: {
                    return Date.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public int getRowCount() {
            return HistoryDialog.this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }
    };
    private DefaultTableCellRenderer coloredRenderer = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int r, int c) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, r, c);
            Long rev = (Long)table.getModel().getValueAt(table.convertRowIndexToModel(r), 0);
            if (HistoryDialog.this.commitRevision == rev) {
                if (HistoryDialog.this.modified) {
                    comp.setForeground(Color.red);
                } else {
                    comp.setForeground(Color.blue);
                }
            } else {
                comp.setForeground(Color.black);
            }
            return comp;
        }
    };
    private DefaultListModel listModel = new DefaultListModel();
    private ListModel sortedListModel = new SortedListModel(this.listModel);
    private Action acceptAction = new AbstractAction("Accept"){

        @Override
        public void actionPerformed(ActionEvent e) {
            HistoryDialog.this.accept = true;
            HistoryDialog.this.setVisible(false);
        }
    };
    private Action closeAction = new AbstractAction("Close"){

        @Override
        public void actionPerformed(ActionEvent e) {
            HistoryDialog.this.setVisible(false);
        }
    };
    private boolean accept = false;
    private JButton acceptButton;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JList jList1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTable jTable1;

    public HistoryDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.acceptButton.setVisible(false);
        this.jTable1.setDefaultRenderer(Object.class, this.coloredRenderer);
        this.jTable1.getColumnModel().getColumn(0).setPreferredWidth(95);
        this.jTable1.getColumnModel().getColumn(1).setPreferredWidth(105);
        this.jTable1.getColumnModel().getColumn(2).setPreferredWidth(95);
        this.jTable1.getColumnModel().getColumn(3).setPreferredWidth(655);
        this.jTable1.setAutoResizeMode(1);
        this.jTable1.getRowSorter().setSortKeys(Collections.singletonList(new RowSorter.SortKey(0, SortOrder.DESCENDING)));
        this.jTable1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int selected = HistoryDialog.this.jTable1.getRowSorter().convertRowIndexToModel(HistoryDialog.this.jTable1.getSelectedRow());
                    HistoryDialog.this.listModel.clear();
                    if (HistoryDialog.this.changeSetPopupMenu != null) {
                        HistoryDialog.this.changeSetPopupMenu.setRevision(SVNRevision.create((long)((SVNLogEntry)HistoryDialog.this.data.get(selected)).getRevision()));
                    }
                    if (HistoryDialog.this.filePopupMenu != null) {
                        HistoryDialog.this.filePopupMenu.setRevision(SVNRevision.create((long)((SVNLogEntry)HistoryDialog.this.data.get(selected)).getRevision()));
                    }
                    Map map = ((SVNLogEntry)HistoryDialog.this.data.get(selected)).getChangedPaths();
                    if (HistoryDialog.this.changeSetPopupMenu != null) {
                        HistoryDialog.this.changeSetPopupMenu.setRows(HistoryDialog.this.location, map.keySet());
                    }
                    for (Object o : map.values()) {
                        HistoryDialog.this.listModel.addElement(o);
                    }
                }
            }
        });
        this.jList1.setVisibleRowCount(6);
        this.jList1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (HistoryDialog.this.filePopupMenu != null) {
                    HistoryDialog.this.filePopupMenu.setRow(HistoryDialog.this.location, HistoryDialog.this.jList1.getSelectedValue());
                }
            }
        });
    }

    public void setLog(List<SVNLogEntry> history) {
        this.data.clear();
        this.minRevision = Long.MAX_VALUE;
        this.maxRevision = Long.MIN_VALUE;
        for (SVNLogEntry entry : history) {
            this.minRevision = Math.min(this.minRevision, entry.getRevision());
            this.maxRevision = Math.max(this.maxRevision, entry.getRevision());
            this.data.add(entry);
        }
        this.tableModel.fireTableDataChanged();
    }

    public void setCommittedRevision(long commitRevision, boolean modified) {
        this.commitRevision = commitRevision;
        this.modified = modified;
    }

    public void setFileRow(Location location, boolean diff, boolean update, boolean revert) {
        this.location = location;
        this.changeSetPopupMenu = new HistoryPopupMenu(false, diff, update, revert, false);
        this.filePopupMenu = new HistoryPopupMenu(true, diff, update, revert, false);
        this.jTable1.setComponentPopupMenu(this.changeSetPopupMenu);
        this.jList1.setComponentPopupMenu(this.filePopupMenu);
    }

    public boolean didAccept() {
        return this.accept;
    }

    public void setAcceptText(String text) {
        this.acceptAction.putValue("Name", text);
        this.acceptButton.setVisible(true);
    }

    public void setMultiSelect(boolean b) {
        if (b) {
            this.jTable1.setSelectionMode(2);
        } else {
            this.jTable1.setSelectionMode(0);
        }
    }

    public List<SVNRevisionRange> getSelectedRevisions() {
        LinkedList<SVNRevisionRange> revisions = new LinkedList<SVNRevisionRange>();
        if (this.jTable1.getSelectedRowCount() == 0 || this.jTable1.getSelectedRowCount() == this.jTable1.getRowCount()) {
            revisions.add(new SVNRevisionRange(SVNRevision.create((long)this.minRevision), SVNRevision.create((long)this.maxRevision)));
        } else {
            for (int i : this.jTable1.getSelectedRows()) {
                int selected = this.jTable1.getRowSorter().convertRowIndexToModel(i);
                long r = this.data.get(selected).getRevision();
                revisions.add(new SVNRevisionRange(SVNRevision.create((long)(r - 1L)), SVNRevision.create((long)r)));
            }
        }
        return revisions;
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.closeButton = new JButton(this.closeAction);
        this.acceptButton = new JButton(this.acceptAction);
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.jList1 = new JList();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.buttonPanel.setName("buttonPanel");
        this.closeButton.setMnemonic('C');
        ResourceMap resourceMap = ((SVNApp)Application.getInstance(SVNApp.class)).getContext().getResourceMap(HistoryDialog.class);
        this.closeButton.setText(resourceMap.getString("closeButton.text", new Object[0]));
        this.closeButton.setName("closeButton");
        this.acceptButton.setText(resourceMap.getString("acceptButton.text", new Object[0]));
        this.acceptButton.setName("acceptButton");
        GroupLayout buttonPanelLayout = new GroupLayout(this.buttonPanel);
        this.buttonPanel.setLayout(buttonPanelLayout);
        buttonPanelLayout.setHorizontalGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, buttonPanelLayout.createSequentialGroup().addContainerGap(552, Short.MAX_VALUE).addComponent(this.acceptButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton).addContainerGap()));
        buttonPanelLayout.setVerticalGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(buttonPanelLayout.createSequentialGroup().addGroup(buttonPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeButton).addComponent(this.acceptButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jSplitPane1.setName("jSplitPane1");
        this.jScrollPane1.setName("jScrollPane1");
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setModel(this.tableModel);
        this.jTable1.setComponentPopupMenu(this.changeSetPopupMenu);
        this.jTable1.setName("jTable1");
        this.jTable1.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jSplitPane1.setTopComponent(this.jScrollPane1);
        this.jScrollPane2.setName("jScrollPane2");
        this.jList1.setModel(this.sortedListModel);
        this.jList1.setName("jList1");
        this.jScrollPane2.setViewportView(this.jList1);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.buttonPanel, -1, -1, Short.MAX_VALUE)).addComponent(this.jSplitPane1, -1, 710, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jSplitPane1, -1, 350, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonPanel, -2, 27, -2)));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 718) / 2, (screenSize.height - 417) / 2, 718, 417);
    }
}

