/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn.dialogs;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.sdrinovsky.sdsvn.SVNApp;
import org.sdrinovsky.sdsvn.SortedListModel;
import org.sdrinovsky.sdsvn.dialogs.HistoryPopupMenu;
import org.sdrinovsky.sdsvn.files.FileTableRow;
import org.sdrinovsky.sdsvn.files.Location;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class CommitFrame
extends JDialog {
    private boolean okPressed;
    private DefaultListModel model = new DefaultListModel();
    private ListModel sortedModel = new SortedListModel(this.model);
    private Location location = null;
    private HistoryPopupMenu filePopupMenu = new HistoryPopupMenu(true, true, false, false, true);
    private JButton cancelButton;
    private JList fileList;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTextPane messageArea;
    private JButton okButton;

    public CommitFrame(Frame owner) {
        super(owner, true);
        this.initComponents();
        try {
            URL resource = CommitFrame.class.getResource("/dict/english.dic");
            if (resource != null) {
                URLConnection resourceConnection = resource.openConnection();
                InputStream in = resourceConnection.getInputStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fileList.setComponentPopupMenu(this.filePopupMenu);
        this.fileList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (CommitFrame.this.filePopupMenu != null) {
                    CommitFrame.this.filePopupMenu.setRows(CommitFrame.this.location, new HashSet<Object>(Arrays.asList(CommitFrame.this.fileList.getSelectedValues())));
                }
            }
        });
        this.filePopupMenu.setRevision(SVNRevision.HEAD);
    }

    public void setMessage(String text) {
        if (text != null) {
            this.messageArea.setText(text);
            this.messageArea.setSelectionStart(0);
            this.messageArea.setSelectionEnd(text.length());
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.okPressed = false;
        }
        super.setVisible(b);
        this.messageArea.grabFocus();
    }

    public void setFiles(List<FileTableRow> files) {
        this.model.clear();
        this.location = null;
        for (FileTableRow file : files) {
            if (this.location == null) {
                this.location = file.getLocation();
            }
            this.model.addElement(file);
        }
    }

    public boolean wasOkPressed() {
        return this.okPressed;
    }

    public String getMessage() {
        return this.messageArea.getText();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane2 = new JScrollPane();
        this.fileList = new JList();
        this.jScrollPane1 = new JScrollPane();
        this.messageArea = new JTextPane();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        ResourceMap resourceMap = ((SVNApp)Application.getInstance(SVNApp.class)).getContext().getResourceMap(CommitFrame.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setName("jSplitPane1");
        this.jScrollPane2.setName("jScrollPane2");
        this.fileList.setModel(this.sortedModel);
        this.fileList.setName("fileList");
        this.jScrollPane2.setViewportView(this.fileList);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.jScrollPane1.setName("jScrollPane1");
        this.messageArea.setName("messageArea");
        this.messageArea.setPreferredSize(new Dimension(6, 128));
        this.jScrollPane1.setViewportView(this.messageArea);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.okButton.setText(resourceMap.getString("okButton.text", new Object[0]));
        this.okButton.setName("okButton");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommitFrame.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(resourceMap.getString("cancelButton.text", new Object[0]));
        this.cancelButton.setName("cancelButton");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommitFrame.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(446, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton).addContainerGap()).addComponent(this.jSplitPane1, -1, 548, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jSplitPane1, -1, 430, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 554) / 2, (screenSize.height - 503) / 2, 554, 503);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.okPressed = true;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

