/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskMonitor;
import org.sdrinovsky.sdsvn.SVNApp;
import org.sdrinovsky.sdsvn.SVNAppAboutBox;
import org.sdrinovsky.sdsvn.dialogs.CommitFrame;
import org.sdrinovsky.sdsvn.dialogs.LoginDialog;
import org.sdrinovsky.sdsvn.files.FileRow;
import org.sdrinovsky.sdsvn.files.FileRowImpl;
import org.sdrinovsky.sdsvn.files.FileTableModel;
import org.sdrinovsky.sdsvn.files.FileTableRenderer;
import org.sdrinovsky.sdsvn.files.FileTableRow;
import org.sdrinovsky.sdsvn.files.Location;
import org.sdrinovsky.sdsvn.tasks.AddTask;
import org.sdrinovsky.sdsvn.tasks.BranchTask;
import org.sdrinovsky.sdsvn.tasks.CheckoutTask;
import org.sdrinovsky.sdsvn.tasks.CleanupTask;
import org.sdrinovsky.sdsvn.tasks.CommitTask;
import org.sdrinovsky.sdsvn.tasks.DiffTask;
import org.sdrinovsky.sdsvn.tasks.GraphTask;
import org.sdrinovsky.sdsvn.tasks.HistoryTask;
import org.sdrinovsky.sdsvn.tasks.MergeTask;
import org.sdrinovsky.sdsvn.tasks.PropertiesTask;
import org.sdrinovsky.sdsvn.tasks.RefreshTask;
import org.sdrinovsky.sdsvn.tasks.ResolveTask;
import org.sdrinovsky.sdsvn.tasks.RevertTask;
import org.sdrinovsky.sdsvn.tasks.SwitchTask;
import org.sdrinovsky.sdsvn.tasks.UpdateTask;
import org.sdrinovsky.sdsvn.tree.RepoTreeView;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SVNAppView
extends FrameView {
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy KK:mm:ss a");
    private boolean showChanged = false;
    private boolean showUpdated = false;
    private boolean showAdded = false;
    private boolean showRemoved = false;
    private boolean showConflicts = false;
    private boolean showMissing = false;
    private boolean hideMissing = false;
    private boolean showUnknown = false;
    private boolean hideUnknown = false;
    private boolean showIgnored = false;
    private Matcher filterMatches = null;
    private FileTableModel model = new FileTableModel();
    private Preferences preferences;
    private long lastRefresh = 0L;
    private int debugTotalFoldersChecked = 0;
    private boolean debugRefresh = false;
    private Thread refreshThread = new Thread(){

        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ex) {
                    return;
                }
                String workingFolder = SVNAppView.this.getWorkingFolder();
                if (workingFolder == null) continue;
                long debug_start = System.currentTimeMillis();
                SVNAppView.this.debugTotalFoldersChecked = 0;
                long lastModifiedTime = SVNAppView.this.getLastModifiedTime(new File(workingFolder), SVNAppView.this.lastRefresh);
                long debug_total = System.currentTimeMillis() - debug_start;
                if (lastModifiedTime > SVNAppView.this.lastRefresh) {
                    if (SVNAppView.this.debugRefresh) {
                        System.out.println("auto-refresh(" + SVNAppView.this.debugTotalFoldersChecked + ", " + debug_total + ")");
                    }
                    SVNAppView.this.doRefresh(true);
                    continue;
                }
                if (!SVNAppView.this.debugRefresh) continue;
                System.out.println("up-to-date(" + SVNAppView.this.debugTotalFoldersChecked + ", " + debug_total + ")");
            }
        }
    };
    String lastMessage = "";
    private RepoTreeView repoView = null;
    private boolean loggedIn = false;
    private boolean tablePopulated = false;
    private boolean rowSelected = false;
    private boolean twoRowsSelected = false;
    private boolean commitableSelected = false;
    private boolean revertableSelected = false;
    private boolean conflictSelected = false;
    private boolean addableSelected = false;
    private JMenuItem AddMenuItem;
    private JMenuItem CleanUpMenuItem;
    private JMenuItem CommitMenuItem;
    private JMenuItem DiffMenuItem;
    private JMenuItem DiffRevisionMenuItem;
    private JPanel FileActionPanel;
    private JMenuItem GraphMenuItem;
    private JMenuItem HistoryMenuItem;
    private JSplitPane InfoPanel;
    private JMenuItem JIndentMenuItem1;
    private JMenu ModifyMenu;
    private JMenuItem PropertiesMenuItem;
    private JMenu QueryMenu;
    private JMenuItem RemoveMenuItem;
    private JPanel RepoActionPanel;
    private JMenu RepoMenu;
    private JMenuItem RevertMenuItem;
    private JMenuItem UpdateREvisionMenuItem;
    private JPanel WorkingCopySettingPanel;
    private JPopupMenu actionPopup;
    private JMenuItem addMenuItem;
    private JMenuItem branchMenuItem;
    private JButton btnAdd;
    private JButton btnBrowse;
    private JButton btnCheckout;
    private JButton btnCleanup;
    private JButton btnCommit;
    private JButton btnDiff;
    private JButton btnGraph;
    private JButton btnHistory;
    private JButton btnJIndent;
    private JButton btnMerge;
    private JButton btnProperties;
    private JButton btnQuit;
    private JButton btnRefresh;
    private JButton btnRemove;
    private JButton btnResolve;
    private JButton btnRevert;
    private JButton btnSwitch;
    private JButton btnUpdate;
    private JComboBox cbWorkingFolder;
    private JMenuItem checkoutMenuItem;
    private JMenuItem commitMenuItem;
    private JMenuItem diffMenuItem;
    private JMenuItem diffProgramMenuItem;
    private JMenuItem diffRevisionMenuItem;
    private JMenuItem diffSelectedFilesMenuItem;
    private JTable fileListing;
    private JMenuItem graphMenuItem;
    private JMenuItem historyMenuItem;
    private JButton jButton1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JSeparator jSeparator5;
    private JToolBar.Separator jSeparator6;
    private JToolBar.Separator jSeparator7;
    private JSeparator jSeparator8;
    private JSeparator jSeparator9;
    private JToolBar jToolBar1;
    private JMenuItem jindentLicenseMenuItem;
    private JMenuItem jindentMenuItem;
    private JMenuItem jindentSettingsMenuItem;
    private JLabel lblRepoPath;
    private JLabel lblWorkingFolder;
    private JMenuItem loginMenuItem;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JMenuItem mergeMenuItem;
    private JMenuItem mergeProgramMenuItem;
    private JTextPane messageTextPane;
    private JMenuItem newProjectmenuItem;
    private JMenuItem openProjectMenuItem;
    private JProgressBar progressBar;
    private JMenuItem propertiesMenuItem;
    private JMenuItem refreshMenuItem;
    private JMenuItem removeMenuItem;
    private JMenuItem repoViewMenuItem;
    private JMenuItem resolveMenuItem;
    private JMenuItem revertMenuItem;
    private JMenu settingsMenu;
    private JToggleButton showBranchesToggleButton;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private JMenuItem switchMenuItem;
    private JTextField tableFilter;
    private JToggleButton tbAdded;
    private JToggleButton tbChanged;
    private JToggleButton tbConflicts;
    private JToggleButton tbHideMissing;
    private JToggleButton tbHideUnknown;
    private JToggleButton tbModified;
    private JToggleButton tbRemoved;
    private JToggleButton tbShowIgnored;
    private JToggleButton tbShowMissing;
    private JToggleButton tbShowUnknown;
    private JToggleButton tbUpdated;
    private JTextField tfRepository;
    private JMenuItem updateMenuItem;
    private JMenuItem updateRevisionMenuItem;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;
    private JFileChooser chooser;
    SVNRevision lastRevision = null;
    String lastBranchName = null;

    private long getLastModifiedTime(File file, long min) {
        File[] children = file.listFiles();
        boolean check = false;
        if (children != null) {
            for (File child : children) {
                if (!".svn".equals(child.getName())) continue;
                check = true;
            }
            if (check) {
                for (File child : children) {
                    if (".svn".equals(child.getName())) continue;
                    min = Math.max(min, this.getLastModifiedTime(child, min));
                }
            }
            return min;
        }
        if (new File(new File(new File(file.getParentFile(), ".svn"), "text-base"), file.getName() + ".svn-base").exists()) {
            ++this.debugTotalFoldersChecked;
            if (this.debugRefresh && min < file.lastModified()) {
                System.out.println(file + " was updated");
            }
            return Math.max(min, file.lastModified());
        }
        return min;
    }

    public SVNAppView(SingleFrameApplication app) {
        super((Application)app);
        this.refreshThread.setPriority(1);
        this.refreshThread.start();
        this.redirectSystemStreams();
        this.preferences = SVNApp.getApplication().getPreferences();
        this.initComponents();
        this.jindentLicenseMenuItem.setVisible(false);
        this.JIndentMenuItem1.setVisible(false);
        this.jindentMenuItem.setVisible(false);
        this.jindentSettingsMenuItem.setVisible(false);
        this.btnJIndent.setVisible(false);
        for (int i = 0; i < FileTableRow.getColumnCount(); ++i) {
            this.fileListing.getColumnModel().getColumn(i).setPreferredWidth(FileTableRow.getColumnWidth(i));
        }
        this.fileListing.setAutoResizeMode(1);
        this.fileListing.setDragEnabled(true);
        this.fileListing.getTableHeader().setReorderingAllowed(false);
        this.fileListing.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && 1 == e.getButton()) {
                    int row = SVNAppView.this.fileListing.rowAtPoint(e.getPoint());
                    int modelRow = SVNAppView.this.fileListing.getRowSorter().convertRowIndexToModel(row);
                    try {
                        File file = SVNAppView.this.model.getRow(modelRow).getFile();
                        if (Desktop.isDesktopSupported()) {
                            SVNAppView.this.statusMessageLabel.setText("Editing file " + file);
                            SVNAppView.this.messageTimer.restart();
                            Desktop.getDesktop().open(file);
                        } else {
                            SVNAppView.this.statusMessageLabel.setText("Editing file " + file);
                            SVNAppView.this.messageTimer.restart();
                            String str = "RUNDLL32.EXE SHELL32.DLL,";
                            str = e.isControlDown() ? str + "OpenAs_RunDLL " : str + "ShellExec_RunDLL ";
                            Runtime r = Runtime.getRuntime();
                            Process p = r.exec(str + file);
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.fileListing.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SVNAppView.this.setRowSelected(SVNAppView.this.fileListing.getSelectedRow() != -1);
            }
        });
        this.fileListing.setDefaultRenderer(Object.class, new FileTableRenderer());
        this.fileListing.setDefaultRenderer(Long.class, new FileTableRenderer());
        this.fileListing.setDefaultRenderer(Date.class, new FileTableRenderer());
        RowFilter<Object, Object> filter = new RowFilter<Object, Object>(){

            @Override
            public boolean include(RowFilter.Entry entry) {
                return this.includeFilter(entry) && this.includeButtons(entry);
            }

            private boolean includeFilter(RowFilter.Entry entry) {
                if (SVNAppView.this.filterMatches != null) {
                    File file = new File((File)entry.getValue(3), entry.getStringValue(1));
                    SVNAppView.this.filterMatches.reset(file.toString());
                    return SVNAppView.this.filterMatches.find();
                }
                return true;
            }

            private boolean includeButtons(RowFilter.Entry entry) {
                boolean showAll = !SVNAppView.this.showAdded && !SVNAppView.this.showChanged && !SVNAppView.this.showConflicts && !SVNAppView.this.showMissing && !SVNAppView.this.showRemoved && !SVNAppView.this.showUnknown;
                String status = entry.getStringValue(0);
                switch (status.charAt(0)) {
                    case 'X': {
                        return showAll;
                    }
                    case 'A': 
                    case 'R': 
                    case '~': {
                        return showAll || SVNAppView.this.showAdded;
                    }
                    case 'D': {
                        return showAll || SVNAppView.this.showRemoved;
                    }
                    case 'M': {
                        return showAll || SVNAppView.this.showChanged;
                    }
                    case 'C': {
                        return showAll || SVNAppView.this.showConflicts;
                    }
                    case 'I': {
                        return (showAll || SVNAppView.this.showUnknown) && SVNAppView.this.showIgnored;
                    }
                    case '?': {
                        return showAll && !SVNAppView.this.hideUnknown || SVNAppView.this.showUnknown;
                    }
                    case '!': {
                        return showAll && !SVNAppView.this.hideMissing || SVNAppView.this.showMissing;
                    }
                }
                switch (status.charAt(1)) {
                    case 'M': {
                        return showAll || SVNAppView.this.showChanged;
                    }
                    case 'C': {
                        return showAll || SVNAppView.this.showConflicts;
                    }
                }
                if (status.charAt(2) == 'L') {
                    return showAll || SVNAppView.this.showChanged;
                }
                if (status.charAt(3) == '+') {
                    return showAll || SVNAppView.this.showAdded || SVNAppView.this.showRemoved;
                }
                if (status.charAt(4) == 'S') {
                    return showAll || SVNAppView.this.showChanged;
                }
                if (status.charAt(5) == 'K') {
                    return showAll || SVNAppView.this.showChanged;
                }
                if (status.charAt(6) == '*') {
                    return showAll || SVNAppView.this.showUpdated;
                }
                return showAll;
            }
        };
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.fileListing.getModel());
        sorter.setRowFilter(filter);
        sorter.toggleSortOrder(1);
        sorter.toggleSortOrder(3);
        this.fileListing.setRowSorter(sorter);
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SVNAppView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SVNAppView.this.busyIconIndex = (SVNAppView.this.busyIconIndex + 1) % SVNAppView.this.busyIcons.length;
                SVNAppView.this.statusAnimationLabel.setIcon(SVNAppView.this.busyIcons[SVNAppView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!SVNAppView.this.busyIconTimer.isRunning()) {
                        SVNAppView.this.statusAnimationLabel.setIcon(SVNAppView.this.busyIcons[0]);
                        SVNAppView.this.busyIconIndex = 0;
                        SVNAppView.this.busyIconTimer.start();
                    }
                    SVNAppView.this.progressBar.setVisible(true);
                    SVNAppView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    SVNAppView.this.busyIconTimer.stop();
                    SVNAppView.this.statusAnimationLabel.setIcon(SVNAppView.this.idleIcon);
                    SVNAppView.this.progressBar.setVisible(false);
                    SVNAppView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    if (text != null) {
                        SVNAppView.this.statusMessageLabel.setText(text);
                        SVNAppView.this.messageTimer.restart();
                        System.out.println(text);
                    }
                } else if ("error".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    if (text != null) {
                        SVNAppView.this.statusMessageLabel.setText(text);
                        SVNAppView.this.messageTimer.restart();
                        System.err.println(text);
                    }
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    SVNAppView.this.progressBar.setVisible(true);
                    SVNAppView.this.progressBar.setIndeterminate(false);
                    SVNAppView.this.progressBar.setValue(value);
                } else if ("status".equals(propertyName)) {
                    SVNAppView.this.model.clear();
                    SVNAppView.this.model.addRows((List)evt.getNewValue());
                    SVNAppView.this.setTablePopulated(true);
                } else if ("refresh".equals(propertyName)) {
                    SVNAppView.this.doRefresh((String)evt.getNewValue(), false, SVNAppView.this.showUpdated);
                } else if ("selected".equals(propertyName)) {
                    int row = SVNAppView.this.model.indexOf(evt.getNewValue());
                    int viewRow = SVNAppView.this.fileListing.getRowSorter().convertRowIndexToView(row);
                    SVNAppView.this.fileListing.getSelectionModel().addSelectionInterval(viewRow, viewRow);
                }
            }
        });
        this.setLoggedIn(this.preferences.get("username", null) != null);
        this.resetButtons();
    }

    public FileTableModel getModel() {
        return this.model;
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = SVNApp.getApplication().getMainFrame();
            this.aboutBox = new SVNAppAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        SVNApp.getApplication().show(this.aboutBox);
    }

    @Action
    public void login() {
        SVNApp.getApplication().show(new LoginDialog());
        this.setLoggedIn(this.preferences.get("username", null) != null);
    }

    @Action
    public void diffProgram() {
        String current = this.preferences.get("diffProgram", null);
        JFileChooser diffChooser = new JFileChooser(current);
        diffChooser.setFileSelectionMode(0);
        if (0 == diffChooser.showOpenDialog(SVNApp.getApplication().getMainFrame())) {
            this.preferences.put("diffProgram", diffChooser.getSelectedFile().toString());
            this.resetButtons();
        }
    }

    @Action
    public void mergeProgram() {
        String current = this.preferences.get("mergeProgram", null);
        JFileChooser diffChooser = new JFileChooser(current);
        diffChooser.setFileSelectionMode(0);
        if (0 == diffChooser.showOpenDialog(SVNApp.getApplication().getMainFrame())) {
            this.preferences.put("mergeProgram", diffChooser.getSelectedFile().toString());
            this.resetButtons();
        }
    }

    @Action
    public void showChooser() {
        this.showChooser("Select Project Folder");
    }

    private void showChooser(String dialogTitle) {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
            this.chooser.setFileSelectionMode(1);
        }
        this.chooser.setDialogTitle(dialogTitle);
        String workingFolder = this.getWorkingFolder();
        if (workingFolder != null) {
            this.chooser.setSelectedFile(new File(workingFolder));
        }
        if (0 == this.chooser.showOpenDialog(SVNApp.getApplication().getMainFrame())) {
            this.cbWorkingFolder.setSelectedItem(this.chooser.getSelectedFile().toString());
            this.doRefresh(false);
        }
    }

    @Action(block=Task.BlockingScope.APPLICATION, enabledProperty="repoEmpty")
    public Task checkout() {
        String repo;
        String workingFolder = this.getWorkingFolder();
        File destination = null;
        if (workingFolder != null) {
            destination = new File(workingFolder);
        }
        if (destination != null && (repo = this.showRepoView(true, false)) != null) {
            try {
                SVNURL url = SVNURL.parseURIEncoded((String)repo);
                SVNRevision revision = SVNRevision.HEAD;
                return new CheckoutTask(SVNApp.getApplication(), url, destination, revision);
            }
            catch (SVNException ex) {
                Logger.getLogger(SVNAppView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    @Action(enabledProperty="repoSet", block=Task.BlockingScope.ACTION)
    public Task update() {
        String workingFolder = this.getWorkingFolder();
        File destination = null;
        if (workingFolder != null) {
            destination = new File(workingFolder);
        }
        if (destination != null) {
            return new UpdateTask(SVNApp.getApplication(), FileRowImpl.getList(destination, null));
        }
        return null;
    }

    @Action(enabledProperty="repoSet", block=Task.BlockingScope.APPLICATION)
    public Task cleanup() {
        String workingFolder = this.getWorkingFolder();
        if (workingFolder != null) {
            File destination = new File(workingFolder);
            return new CleanupTask(SVNApp.getApplication(), destination);
        }
        return null;
    }

    @Action(enabledProperty="revertableSelected")
    public Task revert() {
        List<FileTableRow> files = this.getSelectRows();
        if (this.askConfirm("Confirm Revert", "revert", files)) {
            return new RevertTask(SVNApp.getApplication(), files);
        }
        return null;
    }

    private boolean askConfirm(String title, String question, List<FileTableRow> files) {
        StringBuilder message = new StringBuilder("Are you sure you want to ");
        message.append(question);
        message.append(" the following files:\n");
        int counter = 0;
        for (FileTableRow file : files) {
            if (counter > 20) {
                message.append("...\n");
                break;
            }
            message.append(file.getFile());
            message.append("\n");
            ++counter;
        }
        return 0 == JOptionPane.showConfirmDialog(SVNApp.getApplication().getMainFrame(), message, title, 0, 2);
    }

    @Action(enabledProperty="commitableSelected")
    public Task commit() {
        List<FileTableRow> files = this.getCommitableFiles();
        CommitFrame commitFrame = new CommitFrame(SVNApp.getApplication().getMainFrame());
        commitFrame.setMessage(this.lastMessage);
        commitFrame.setFiles(files);
        commitFrame.setVisible(true);
        this.lastMessage = commitFrame.getMessage();
        if (commitFrame.wasOkPressed()) {
            return new CommitTask(SVNApp.getApplication(), files, this.lastMessage);
        }
        return null;
    }

    @Action(enabledProperty="addableSelected")
    public Task add() {
        return new AddTask(SVNApp.getApplication(), this.getAddableFiles());
    }

    @Action(block=Task.BlockingScope.ACTION, enabledProperty="repoSet")
    public Task refresh() {
        return this.refresh(null, this.showUpdated);
    }

    public Task refresh(String message, boolean updated) {
        this.lastRefresh = System.currentTimeMillis();
        List<File> selected = this.getSelectFiles();
        String workingFolder = this.getWorkingFolder();
        if (workingFolder != null) {
            SVNInfo info = SVNApp.getApplication().getFileInfo(new File(workingFolder));
            if (info != null) {
                this.setRepo(info.getURL().toString() + "@" + info.getRevision().getNumber());
            } else {
                this.setRepo("");
            }
            RefreshTask task = new RefreshTask(SVNApp.getApplication(), new File(workingFolder), selected, updated);
            task.setMessageText(message);
            return task;
        }
        return null;
    }

    @Action(enabledProperty="diffEnabled")
    public Task diff() {
        return new DiffTask(SVNApp.getApplication(), this.getSelectRows());
    }

    @Action(enabledProperty="rowSelected")
    public Task graph() {
        FileTableRow row = this.getSelectRows().get(0);
        LinkedList<String> branches = new LinkedList<String>();
        branches.add("trunk");
        Location location = row.getLocation();
        if (location != null && !"trunk".equals(location.getBranch())) {
            branches.add(location.getBranch());
        }
        if (this.showBranchesToggleButton.isSelected()) {
            try {
                SVNDirEntry entry;
                SVNURL url = this.getRootURL();
                SVNRepository repo = SVNApp.getApplication().getSVNClientManager().createRepository(url, true);
                Collection collection = repo.getDir("branches", -1L, null, (Collection)null);
                for (Object o : collection) {
                    entry = (SVNDirEntry)o;
                    branches.add("branches/" + entry.getName());
                }
                collection = repo.getDir("tags", -1L, null, (Collection)null);
                for (Object o : collection) {
                    entry = (SVNDirEntry)o;
                    branches.add("tags/" + entry.getName());
                }
            }
            catch (SVNException ex) {
                Logger.getLogger(SVNAppView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return new GraphTask(SVNApp.getApplication(), row, row.getLocation(), branches);
    }

    @Action(enabledProperty="repoSet", block=Task.BlockingScope.APPLICATION)
    public Task switchWorkingCopy() {
        String repo = this.showRepoView(true, false);
        if (repo != null) {
            String switchTo = FileTableRow.switchBranch(this.getURL().toString(), FileTableRow.parseURL(repo, 1));
            try {
                SVNURL url = SVNURL.parseURIEncoded((String)switchTo);
                SVNRevision revision = SVNRevision.HEAD;
                String workingFolder = this.getWorkingFolder();
                if (workingFolder != null) {
                    File destination = new File(workingFolder);
                    return new SwitchTask(SVNApp.getApplication(), url, destination, revision);
                }
            }
            catch (SVNException ex) {
                Logger.getLogger(SVNAppView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public boolean isFalse() {
        return false;
    }

    public void setFalse(boolean b) {
    }

    @Action(block=Task.BlockingScope.APPLICATION, enabledProperty="repoSet")
    public Task mergeWorkingCopy() {
        String repo = this.showRepoView(true, false);
        if (repo != null) {
            try {
                SVNURL url = SVNURL.parseURIEncoded((String)repo);
                SVNRevision revision = SVNRevision.HEAD;
                String workingFolder = this.getWorkingFolder();
                if (workingFolder != null) {
                    SVNURL from = this.getURL();
                    File destination = new File(workingFolder);
                    List<FileRow> rows = FileRowImpl.getList(destination, new Location(destination, repo));
                    return new MergeTask(SVNApp.getApplication(), url, rows, from, revision);
                }
            }
            catch (SVNException ex) {
                Logger.getLogger(SVNAppView.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            System.out.println("Merge Canceled");
        }
        return null;
    }

    public String getWorkingFolder() {
        String item = null;
        Object selectedItem = this.cbWorkingFolder.getSelectedItem();
        if (selectedItem != null) {
            item = selectedItem.toString();
            DefaultComboBoxModel cbModel = (DefaultComboBoxModel)this.cbWorkingFolder.getModel();
            if (cbModel.getIndexOf(item) != 0) {
                cbModel.removeElement(item);
                cbModel.insertElementAt(item, 0);
                this.cbWorkingFolder.setSelectedIndex(0);
            }
        }
        return item;
    }

    public SVNURL getRootURL() {
        return SVNApp.getApplication().getRootURL(new File(this.getWorkingFolder()));
    }

    public SVNURL getURL() {
        SVNInfo info = SVNApp.getApplication().getFileInfo(new File(this.getWorkingFolder()));
        return info.getURL();
    }

    public String showRepoView(boolean modal, boolean recursive) {
        SVNURL url = this.getRootURL();
        String urlString = null;
        if (url != null) {
            urlString = url.toString();
        }
        if (this.repoView == null) {
            this.repoView = new RepoTreeView((Frame)SVNApp.getApplication().getMainFrame(), modal, urlString, recursive);
        }
        this.repoView.loadRepo(urlString, true);
        this.repoView.setVisible(true);
        if (modal) {
            String repo = this.repoView.getSelectedPath();
            System.out.println("repo: " + repo);
            return repo;
        }
        return null;
    }

    public List<FileTableRow> getSelectRows() {
        LinkedList<FileTableRow> list = new LinkedList<FileTableRow>();
        for (int row : this.fileListing.getSelectedRows()) {
            int realRow = this.fileListing.getRowSorter().convertRowIndexToModel(row);
            list.add(this.model.getRow(realRow));
        }
        return list;
    }

    public List<File> getSelectFiles() {
        LinkedList<File> list = new LinkedList<File>();
        for (int row : this.fileListing.getSelectedRows()) {
            int realRow = this.fileListing.getRowSorter().convertRowIndexToModel(row);
            list.add(this.model.getRow(realRow).getFile());
        }
        return list;
    }

    public List<FileTableRow> getCommitableFiles() {
        LinkedList<FileTableRow> list = new LinkedList<FileTableRow>();
        for (int row : this.fileListing.getSelectedRows()) {
            int realRow = this.fileListing.getRowSorter().convertRowIndexToModel(row);
            FileTableRow ftr = this.model.getRow(realRow);
            if (!ftr.isCommitable()) continue;
            list.add(ftr);
        }
        return list;
    }

    public List<File> getAddableFiles() {
        LinkedList<File> list = new LinkedList<File>();
        for (int row : this.fileListing.getSelectedRows()) {
            int realRow = this.fileListing.getRowSorter().convertRowIndexToModel(row);
            FileTableRow ftr = this.model.getRow(realRow);
            if (!ftr.isAddable()) continue;
            list.add(ftr.getFile());
        }
        return list;
    }

    public void fixButtons() {
        this.showChanged = this.tbChanged.isSelected();
        this.showUpdated = this.tbUpdated.isSelected();
        this.showAdded = this.tbAdded.isSelected();
        this.showRemoved = this.tbRemoved.isSelected();
        this.showConflicts = this.tbConflicts.isSelected();
        this.showMissing = this.tbShowMissing.isSelected();
        this.hideMissing = this.tbHideMissing.isSelected();
        this.showUnknown = this.tbShowUnknown.isSelected();
        this.hideUnknown = this.tbHideUnknown.isSelected();
        this.showIgnored = this.tbShowIgnored.isSelected();
        this.tableFilter.setText("");
        this.updateToolBar();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.RepoActionPanel = new JPanel();
        this.btnCheckout = new JButton();
        this.btnRefresh = new JButton();
        this.btnUpdate = new JButton();
        this.btnMerge = new JButton();
        this.jButton1 = new JButton();
        this.btnSwitch = new JButton();
        this.btnCleanup = new JButton();
        this.jToolBar1 = new JToolBar();
        this.tbModified = new JToggleButton();
        this.tbChanged = new JToggleButton();
        this.tbAdded = new JToggleButton();
        this.tbRemoved = new JToggleButton();
        this.tbConflicts = new JToggleButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.tbShowMissing = new JToggleButton();
        this.tbHideMissing = new JToggleButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.tbShowUnknown = new JToggleButton();
        this.tbHideUnknown = new JToggleButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.tbShowIgnored = new JToggleButton();
        this.tbUpdated = new JToggleButton();
        this.jSeparator6 = new JToolBar.Separator();
        this.tableFilter = new JTextField();
        this.jSeparator7 = new JToolBar.Separator();
        this.showBranchesToggleButton = new JToggleButton();
        this.InfoPanel = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.fileListing = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.messageTextPane = new JTextPane();
        this.FileActionPanel = new JPanel();
        this.btnJIndent = new JButton();
        this.btnDiff = new JButton();
        this.btnGraph = new JButton();
        this.btnHistory = new JButton();
        this.btnProperties = new JButton();
        this.btnResolve = new JButton();
        this.btnCommit = new JButton();
        this.btnAdd = new JButton();
        this.btnRemove = new JButton();
        this.btnRevert = new JButton();
        this.btnQuit = new JButton();
        this.WorkingCopySettingPanel = new JPanel();
        this.lblRepoPath = new JLabel();
        this.tfRepository = new JTextField();
        this.lblWorkingFolder = new JLabel();
        this.cbWorkingFolder = new JComboBox();
        this.btnBrowse = new JButton();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.newProjectmenuItem = new JMenuItem();
        this.openProjectMenuItem = new JMenuItem();
        this.repoViewMenuItem = new JMenuItem();
        this.jSeparator8 = new JSeparator();
        JMenuItem exitMenuItem = new JMenuItem();
        this.settingsMenu = new JMenu();
        this.loginMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jindentSettingsMenuItem = new JMenuItem();
        this.jindentLicenseMenuItem = new JMenuItem();
        this.jSeparator9 = new JSeparator();
        this.diffProgramMenuItem = new JMenuItem();
        this.mergeProgramMenuItem = new JMenuItem();
        this.RepoMenu = new JMenu();
        this.checkoutMenuItem = new JMenuItem();
        this.refreshMenuItem = new JMenuItem();
        this.updateMenuItem = new JMenuItem();
        this.mergeMenuItem = new JMenuItem();
        this.branchMenuItem = new JMenuItem();
        this.switchMenuItem = new JMenuItem();
        this.CleanUpMenuItem = new JMenuItem();
        this.ModifyMenu = new JMenu();
        this.JIndentMenuItem1 = new JMenuItem();
        this.CommitMenuItem = new JMenuItem();
        this.AddMenuItem = new JMenuItem();
        this.RemoveMenuItem = new JMenuItem();
        this.RevertMenuItem = new JMenuItem();
        this.UpdateREvisionMenuItem = new JMenuItem();
        this.QueryMenu = new JMenu();
        this.DiffMenuItem = new JMenuItem();
        this.DiffRevisionMenuItem = new JMenuItem();
        this.GraphMenuItem = new JMenuItem();
        this.HistoryMenuItem = new JMenuItem();
        this.PropertiesMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.actionPopup = new JPopupMenu();
        this.jindentMenuItem = new JMenuItem();
        this.diffMenuItem = new JMenuItem();
        this.diffRevisionMenuItem = new JMenuItem();
        this.diffSelectedFilesMenuItem = new JMenuItem();
        this.graphMenuItem = new JMenuItem();
        this.historyMenuItem = new JMenuItem();
        this.propertiesMenuItem = new JMenuItem();
        this.resolveMenuItem = new JMenuItem();
        this.jSeparator5 = new JSeparator();
        this.commitMenuItem = new JMenuItem();
        this.addMenuItem = new JMenuItem();
        this.removeMenuItem = new JMenuItem();
        this.revertMenuItem = new JMenuItem();
        this.updateRevisionMenuItem = new JMenuItem();
        this.mainPanel.setName("mainPanel");
        this.RepoActionPanel.setName("RepoActionPanel");
        ApplicationActionMap actionMap = ((SVNApp)Application.getInstance(SVNApp.class)).getContext().getActionMap(SVNAppView.class, (Object)this);
        this.btnCheckout.setAction(actionMap.get("checkout"));
        this.btnCheckout.setName("btnCheckout");
        this.btnRefresh.setAction(actionMap.get("refresh"));
        this.btnRefresh.setName("btnRefresh");
        this.btnUpdate.setAction(actionMap.get("update"));
        this.btnUpdate.setName("btnUpdate");
        this.btnMerge.setAction(actionMap.get("mergeWorkingCopy"));
        this.btnMerge.setName("btnMerge");
        this.jButton1.setAction(actionMap.get("copyWorkingCopy"));
        this.jButton1.setName("jButton1");
        this.btnSwitch.setAction(actionMap.get("switchWorkingCopy"));
        this.btnSwitch.setName("btnSwitch");
        this.btnCleanup.setAction(actionMap.get("cleanup"));
        this.btnCleanup.setName("btnCleanup");
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setName("jToolBar1");
        this.tbModified.setAction(actionMap.get("showModified"));
        this.tbModified.setFocusable(false);
        this.tbModified.setHorizontalTextPosition(0);
        this.tbModified.setName("tbModified");
        this.tbModified.setVerticalTextPosition(3);
        this.jToolBar1.add(this.tbModified);
        this.tbChanged.setAction(actionMap.get("showChanged"));
        this.tbChanged.setFocusable(false);
        this.tbChanged.setHorizontalTextPosition(0);
        this.tbChanged.setName("tbChanged");
        this.tbChanged.setVerticalTextPosition(3);
        this.jToolBar1.add(this.tbChanged);
        this.tbAdded.setAction(actionMap.get("showAdded"));
        this.tbAdded.setFocusable(false);
        this.tbAdded.setHorizontalTextPosition(0);
        this.tbAdded.setName("tbAdded");
        this.tbAdded.setVerticalTextPosition(3);
        this.jToolBar1.add(this.tbAdded);
        this.tbRemoved.setAction(actionMap.get("showRemoved"));
        this.tbRemoved.setFocusable(false);
        this.tbRemoved.setHorizontalTextPosition(0);
        this.tbRemoved.setName("tbRemoved");
        this.tbRemoved.setVerticalTextPosition(3);
        this.jToolBar1.add(this.tbRemoved);
        this.tbConflicts.setAction(actionMap.get("showConflicts"));
        this.tbConflicts.setFocusable(false);
        this.tbConflicts.setHorizontalTextPosition(0);
        this.tbConflicts.setName("tbConflicts");
        this.tbConflicts.setVerticalTextPosition(3);
        this.jToolBar1.add(this.tbConflicts);
        this.jSeparator2.setName("jSeparator2");
        this.jToolBar1.add(this.jSeparator2);
        this.tbShowMissing.setAction(actionMap.get("showMissing"));
        this.tbShowMissing.setFocusable(false);
        this.tbShowMissing.setHorizontalTextPosition(0);
        this.tbShowMissing.setName("tbShowMissing");
        this.tbShowMissing.setVerticalTextPosition(3);
        this.jToolBar1.add(this.tbShowMissing);
        this.tbHideMissing.setAction(actionMap.get("hideMissing"));
        this.tbHideMissing.setFocusable(false);
        this.tbHideMissing.setHorizontalTextPosition(0);
        this.tbHideMissing.setName("tbHideMissing");
        this.tbHideMissing.setVerticalTextPosition(3);
        this.jToolBar1.add(this.tbHideMissing);
        this.jSeparator3.setName("jSeparator3");
        this.jToolBar1.add(this.jSeparator3);
        this.tbShowUnknown.setAction(actionMap.get("showUnknown"));
        this.tbShowUnknown.setFocusable(false);
        this.tbShowUnknown.setHorizontalTextPosition(0);
        this.tbShowUnknown.setName("tbShowUnknown");
        this.tbShowUnknown.setVerticalTextPosition(3);
        this.jToolBar1.add(this.tbShowUnknown);
        this.tbHideUnknown.setAction(actionMap.get("hideUnknown"));
        this.tbHideUnknown.setFocusable(false);
        this.tbHideUnknown.setHorizontalTextPosition(0);
        this.tbHideUnknown.setName("tbHideUnknown");
        this.tbHideUnknown.setVerticalTextPosition(3);
        this.jToolBar1.add(this.tbHideUnknown);
        this.jSeparator4.setName("jSeparator4");
        this.jToolBar1.add(this.jSeparator4);
        this.tbShowIgnored.setAction(actionMap.get("showIgnored"));
        this.tbShowIgnored.setFocusable(false);
        this.tbShowIgnored.setHorizontalTextPosition(0);
        this.tbShowIgnored.setName("tbShowIgnored");
        this.tbShowIgnored.setVerticalTextPosition(3);
        this.jToolBar1.add(this.tbShowIgnored);
        this.tbUpdated.setAction(actionMap.get("showUpdated"));
        this.tbUpdated.setFocusable(false);
        this.tbUpdated.setHorizontalTextPosition(0);
        this.tbUpdated.setName("tbUpdated");
        this.tbUpdated.setVerticalTextPosition(3);
        this.jToolBar1.add(this.tbUpdated);
        this.jSeparator6.setName("jSeparator6");
        this.jToolBar1.add(this.jSeparator6);
        this.tableFilter.setColumns(12);
        this.tableFilter.setName("tableFilter");
        this.tableFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVNAppView.this.tableFilterActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.tableFilter);
        this.jSeparator7.setName("jSeparator7");
        this.jToolBar1.add(this.jSeparator7);
        this.showBranchesToggleButton.setAction(actionMap.get("showBranchesInGraph"));
        this.showBranchesToggleButton.setFocusable(false);
        this.showBranchesToggleButton.setHideActionText(true);
        this.showBranchesToggleButton.setHorizontalTextPosition(0);
        this.showBranchesToggleButton.setName("showBranchesToggleButton");
        this.showBranchesToggleButton.setVerticalTextPosition(3);
        this.jToolBar1.add(this.showBranchesToggleButton);
        GroupLayout RepoActionPanelLayout = new GroupLayout(this.RepoActionPanel);
        this.RepoActionPanel.setLayout(RepoActionPanelLayout);
        RepoActionPanelLayout.setHorizontalGroup(RepoActionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(RepoActionPanelLayout.createSequentialGroup().addComponent(this.btnCheckout).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRefresh).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnUpdate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnMerge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSwitch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCleanup).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToolBar1, -2, -1, -2)));
        RepoActionPanelLayout.setVerticalGroup(RepoActionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(RepoActionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCleanup).addComponent(this.btnSwitch).addComponent(this.btnMerge).addComponent(this.btnUpdate).addComponent(this.btnRefresh).addComponent(this.btnCheckout).addComponent(this.jButton1)).addComponent(this.jToolBar1, -2, 28, -2));
        this.InfoPanel.setDividerLocation(250);
        this.InfoPanel.setDividerSize(7);
        this.InfoPanel.setOrientation(0);
        this.InfoPanel.setResizeWeight(1.0);
        this.InfoPanel.setName("InfoPanel");
        this.InfoPanel.setOneTouchExpandable(true);
        this.jScrollPane1.setName("jScrollPane1");
        this.fileListing.setModel(this.model);
        this.fileListing.setComponentPopupMenu(this.actionPopup);
        this.fileListing.setName("fileListing");
        this.jScrollPane1.setViewportView(this.fileListing);
        this.InfoPanel.setLeftComponent(this.jScrollPane1);
        this.jScrollPane2.setName("jScrollPane2");
        this.messageTextPane.setName("messageTextPane");
        this.jScrollPane2.setViewportView(this.messageTextPane);
        this.InfoPanel.setRightComponent(this.jScrollPane2);
        this.FileActionPanel.setName("FileActionPanel");
        this.btnJIndent.setAction(actionMap.get("jindent"));
        this.btnJIndent.setName("btnJIndent");
        this.btnDiff.setAction(actionMap.get("diff"));
        this.btnDiff.setName("btnDiff");
        this.btnGraph.setAction(actionMap.get("graph"));
        this.btnGraph.setName("btnGraph");
        this.btnHistory.setAction(actionMap.get("history"));
        this.btnHistory.setName("btnHistory");
        this.btnProperties.setAction(actionMap.get("properties"));
        this.btnProperties.setName("btnProperties");
        this.btnResolve.setAction(actionMap.get("resolveConflict"));
        this.btnResolve.setName("btnResolve");
        this.btnCommit.setAction(actionMap.get("commit"));
        this.btnCommit.setName("btnCommit");
        this.btnAdd.setAction(actionMap.get("add"));
        this.btnAdd.setName("btnAdd");
        this.btnRemove.setAction(actionMap.get("remove"));
        this.btnRemove.setName("btnRemove");
        this.btnRevert.setAction(actionMap.get("revert"));
        this.btnRevert.setName("btnRevert");
        this.btnQuit.setAction(actionMap.get("quit"));
        this.btnQuit.setName("btnQuit");
        GroupLayout FileActionPanelLayout = new GroupLayout(this.FileActionPanel);
        this.FileActionPanel.setLayout(FileActionPanelLayout);
        FileActionPanelLayout.setHorizontalGroup(FileActionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(FileActionPanelLayout.createSequentialGroup().addComponent(this.btnJIndent).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDiff).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnResolve).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnGraph).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnHistory).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnProperties).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCommit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRemove).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRevert).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 336, Short.MAX_VALUE).addComponent(this.btnQuit)));
        FileActionPanelLayout.setVerticalGroup(FileActionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(FileActionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnJIndent).addComponent(this.btnQuit).addComponent(this.btnDiff).addComponent(this.btnResolve).addComponent(this.btnGraph).addComponent(this.btnHistory).addComponent(this.btnProperties).addComponent(this.btnCommit).addComponent(this.btnAdd).addComponent(this.btnRemove).addComponent(this.btnRevert)));
        this.WorkingCopySettingPanel.setName("WorkingCopySettingPanel");
        this.lblRepoPath.setHorizontalAlignment(11);
        this.lblRepoPath.setLabelFor(this.tfRepository);
        ResourceMap resourceMap = ((SVNApp)Application.getInstance(SVNApp.class)).getContext().getResourceMap(SVNAppView.class);
        this.lblRepoPath.setText(resourceMap.getString("lblRepoPath.text", new Object[0]));
        this.lblRepoPath.setName("lblRepoPath");
        this.tfRepository.setEditable(false);
        this.tfRepository.setName("tfRepository");
        this.lblWorkingFolder.setDisplayedMnemonic('W');
        this.lblWorkingFolder.setLabelFor(this.cbWorkingFolder);
        this.lblWorkingFolder.setText(resourceMap.getString("lblWorkingFolder.text", new Object[0]));
        this.lblWorkingFolder.setName("lblWorkingFolder");
        this.cbWorkingFolder.setEditable(true);
        this.cbWorkingFolder.setName("cbWorkingFolder");
        this.cbWorkingFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SVNAppView.this.cbWorkingFolderActionPerformed(evt);
            }
        });
        this.btnBrowse.setAction(actionMap.get("showChooser"));
        this.btnBrowse.setName("btnBrowse");
        GroupLayout WorkingCopySettingPanelLayout = new GroupLayout(this.WorkingCopySettingPanel);
        this.WorkingCopySettingPanel.setLayout(WorkingCopySettingPanelLayout);
        WorkingCopySettingPanelLayout.setHorizontalGroup(WorkingCopySettingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(WorkingCopySettingPanelLayout.createSequentialGroup().addGroup(WorkingCopySettingPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.lblRepoPath, -1, -1, Short.MAX_VALUE).addComponent(this.lblWorkingFolder)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(WorkingCopySettingPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(WorkingCopySettingPanelLayout.createSequentialGroup().addComponent(this.cbWorkingFolder, 0, 950, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnBrowse, -2, 79, -2)).addComponent(this.tfRepository, -1, 1035, Short.MAX_VALUE))));
        WorkingCopySettingPanelLayout.setVerticalGroup(WorkingCopySettingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(WorkingCopySettingPanelLayout.createSequentialGroup().addGroup(WorkingCopySettingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbWorkingFolder, -2, -1, -2).addComponent(this.btnBrowse)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(WorkingCopySettingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfRepository, -2, -1, -2).addComponent(this.lblRepoPath))).addGroup(WorkingCopySettingPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lblWorkingFolder)));
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.WorkingCopySettingPanel, -1, -1, Short.MAX_VALUE).addGap(24, 24, 24)).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.RepoActionPanel, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.InfoPanel, GroupLayout.Alignment.LEADING, -1, 1169, Short.MAX_VALUE).addComponent(this.FileActionPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.WorkingCopySettingPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.RepoActionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.InfoPanel, -1, 370, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.FileActionPanel, -2, -1, -2).addContainerGap()));
        this.menuBar.setName("menuBar");
        fileMenu.setMnemonic('F');
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        this.newProjectmenuItem.setAction(actionMap.get("newProject"));
        this.newProjectmenuItem.setName("newProjectmenuItem");
        fileMenu.add(this.newProjectmenuItem);
        this.openProjectMenuItem.setAction(actionMap.get("openProject"));
        this.openProjectMenuItem.setName("openProjectMenuItem");
        fileMenu.add(this.openProjectMenuItem);
        this.repoViewMenuItem.setAction(actionMap.get("repoview"));
        this.repoViewMenuItem.setName("repoViewMenuItem");
        fileMenu.add(this.repoViewMenuItem);
        this.jSeparator8.setName("jSeparator8");
        fileMenu.add(this.jSeparator8);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setText(resourceMap.getString("exitMenuItem.text", new Object[0]));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        this.settingsMenu.setMnemonic('S');
        this.settingsMenu.setText(resourceMap.getString("settingsMenu.text", new Object[0]));
        this.settingsMenu.setName("settingsMenu");
        this.loginMenuItem.setAction(actionMap.get("login"));
        this.loginMenuItem.setName("loginMenuItem");
        this.settingsMenu.add(this.loginMenuItem);
        this.jSeparator1.setName("jSeparator1");
        this.settingsMenu.add(this.jSeparator1);
        this.jindentSettingsMenuItem.setAction(actionMap.get("jindentSettings"));
        this.jindentSettingsMenuItem.setName("jindentSettingsMenuItem");
        this.settingsMenu.add(this.jindentSettingsMenuItem);
        this.jindentLicenseMenuItem.setAction(actionMap.get("jindentLicense"));
        this.jindentLicenseMenuItem.setName("jindentLicenseMenuItem");
        this.settingsMenu.add(this.jindentLicenseMenuItem);
        this.jSeparator9.setName("jSeparator9");
        this.settingsMenu.add(this.jSeparator9);
        this.diffProgramMenuItem.setAction(actionMap.get("diffProgram"));
        this.diffProgramMenuItem.setName("diffProgramMenuItem");
        this.settingsMenu.add(this.diffProgramMenuItem);
        this.mergeProgramMenuItem.setAction(actionMap.get("mergeProgram"));
        this.mergeProgramMenuItem.setName("mergeProgramMenuItem");
        this.settingsMenu.add(this.mergeProgramMenuItem);
        this.menuBar.add(this.settingsMenu);
        this.RepoMenu.setMnemonic('R');
        this.RepoMenu.setText(resourceMap.getString("RepoMenu.text", new Object[0]));
        this.RepoMenu.setName("RepoMenu");
        this.checkoutMenuItem.setAction(actionMap.get("checkout"));
        this.checkoutMenuItem.setName("checkoutMenuItem");
        this.RepoMenu.add(this.checkoutMenuItem);
        this.refreshMenuItem.setAction(actionMap.get("refresh"));
        this.refreshMenuItem.setName("refreshMenuItem");
        this.RepoMenu.add(this.refreshMenuItem);
        this.updateMenuItem.setAction(actionMap.get("update"));
        this.updateMenuItem.setName("updateMenuItem");
        this.RepoMenu.add(this.updateMenuItem);
        this.mergeMenuItem.setAction(actionMap.get("mergeWorkingCopy"));
        this.mergeMenuItem.setName("mergeMenuItem");
        this.RepoMenu.add(this.mergeMenuItem);
        this.branchMenuItem.setAction(actionMap.get("copyWorkingCopy"));
        this.branchMenuItem.setName("branchMenuItem");
        this.RepoMenu.add(this.branchMenuItem);
        this.switchMenuItem.setAction(actionMap.get("switchWorkingCopy"));
        this.switchMenuItem.setName("switchMenuItem");
        this.RepoMenu.add(this.switchMenuItem);
        this.CleanUpMenuItem.setAction(actionMap.get("cleanup"));
        this.CleanUpMenuItem.setName("CleanUpMenuItem");
        this.RepoMenu.add(this.CleanUpMenuItem);
        this.menuBar.add(this.RepoMenu);
        this.ModifyMenu.setMnemonic('M');
        this.ModifyMenu.setText(resourceMap.getString("ModifyMenu.text", new Object[0]));
        this.ModifyMenu.setName("ModifyMenu");
        this.JIndentMenuItem1.setAction(actionMap.get("jindent"));
        this.JIndentMenuItem1.setName("JIndentMenuItem1");
        this.ModifyMenu.add(this.JIndentMenuItem1);
        this.CommitMenuItem.setAction(actionMap.get("commit"));
        this.CommitMenuItem.setName("CommitMenuItem");
        this.ModifyMenu.add(this.CommitMenuItem);
        this.AddMenuItem.setAction(actionMap.get("add"));
        this.AddMenuItem.setName("AddMenuItem");
        this.ModifyMenu.add(this.AddMenuItem);
        this.RemoveMenuItem.setAction(actionMap.get("remove"));
        this.RemoveMenuItem.setName("RemoveMenuItem");
        this.ModifyMenu.add(this.RemoveMenuItem);
        this.RevertMenuItem.setAction(actionMap.get("revert"));
        this.RevertMenuItem.setName("RevertMenuItem");
        this.ModifyMenu.add(this.RevertMenuItem);
        this.UpdateREvisionMenuItem.setAction(actionMap.get("updateToRevision"));
        this.UpdateREvisionMenuItem.setName("UpdateREvisionMenuItem");
        this.ModifyMenu.add(this.UpdateREvisionMenuItem);
        this.menuBar.add(this.ModifyMenu);
        this.QueryMenu.setMnemonic('Q');
        this.QueryMenu.setText(resourceMap.getString("QueryMenu.text", new Object[0]));
        this.QueryMenu.setName("QueryMenu");
        this.DiffMenuItem.setAction(actionMap.get("diff"));
        this.DiffMenuItem.setName("DiffMenuItem");
        this.QueryMenu.add(this.DiffMenuItem);
        this.DiffRevisionMenuItem.setAction(actionMap.get("diffWithRevision"));
        this.DiffRevisionMenuItem.setName("DiffRevisionMenuItem");
        this.QueryMenu.add(this.DiffRevisionMenuItem);
        this.GraphMenuItem.setAction(actionMap.get("graph"));
        this.GraphMenuItem.setName("GraphMenuItem");
        this.QueryMenu.add(this.GraphMenuItem);
        this.HistoryMenuItem.setAction(actionMap.get("history"));
        this.HistoryMenuItem.setName("HistoryMenuItem");
        this.QueryMenu.add(this.HistoryMenuItem);
        this.PropertiesMenuItem.setAction(actionMap.get("properties"));
        this.PropertiesMenuItem.setName("PropertiesMenuItem");
        this.QueryMenu.add(this.PropertiesMenuItem);
        this.menuBar.add(this.QueryMenu);
        helpMenu.setMnemonic('H');
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        this.statusPanel.setPreferredSize(new Dimension(0, 28));
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setMinimumSize(new Dimension(146, 19));
        this.progressBar.setName("progressBar");
        this.progressBar.setStringPainted(true);
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 1198, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 1016, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.actionPopup.setName("actionPopup");
        this.jindentMenuItem.setAction(actionMap.get("jindent"));
        this.jindentMenuItem.setName("jindentMenuItem");
        this.actionPopup.add(this.jindentMenuItem);
        this.diffMenuItem.setAction(actionMap.get("diff"));
        this.diffMenuItem.setName("diffMenuItem");
        this.actionPopup.add(this.diffMenuItem);
        this.diffRevisionMenuItem.setAction(actionMap.get("diffWithRevision"));
        this.diffRevisionMenuItem.setName("diffRevisionMenuItem");
        this.actionPopup.add(this.diffRevisionMenuItem);
        this.diffSelectedFilesMenuItem.setAction(actionMap.get("diffSelectedFiles"));
        this.diffSelectedFilesMenuItem.setName("diffSelectedFilesMenuItem");
        this.actionPopup.add(this.diffSelectedFilesMenuItem);
        this.graphMenuItem.setAction(actionMap.get("graph"));
        this.graphMenuItem.setName("graphMenuItem");
        this.actionPopup.add(this.graphMenuItem);
        this.historyMenuItem.setAction(actionMap.get("history"));
        this.historyMenuItem.setName("historyMenuItem");
        this.actionPopup.add(this.historyMenuItem);
        this.propertiesMenuItem.setAction(actionMap.get("properties"));
        this.propertiesMenuItem.setName("propertiesMenuItem");
        this.actionPopup.add(this.propertiesMenuItem);
        this.resolveMenuItem.setAction(actionMap.get("resolveConflict"));
        this.resolveMenuItem.setName("resolveMenuItem");
        this.actionPopup.add(this.resolveMenuItem);
        this.jSeparator5.setName("jSeparator5");
        this.actionPopup.add(this.jSeparator5);
        this.commitMenuItem.setAction(actionMap.get("commit"));
        this.commitMenuItem.setName("commitMenuItem");
        this.actionPopup.add(this.commitMenuItem);
        this.addMenuItem.setAction(actionMap.get("add"));
        this.addMenuItem.setName("addMenuItem");
        this.actionPopup.add(this.addMenuItem);
        this.removeMenuItem.setAction(actionMap.get("remove"));
        this.removeMenuItem.setName("removeMenuItem");
        this.actionPopup.add(this.removeMenuItem);
        this.revertMenuItem.setAction(actionMap.get("revert"));
        this.revertMenuItem.setName("revertMenuItem");
        this.actionPopup.add(this.revertMenuItem);
        this.updateRevisionMenuItem.setAction(actionMap.get("updateToRevision"));
        this.updateRevisionMenuItem.setName("updateRevisionMenuItem");
        this.actionPopup.add(this.updateRevisionMenuItem);
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void cbWorkingFolderActionPerformed(ActionEvent evt) {
        this.doRefresh(false);
    }

    private void tableFilterActionPerformed(ActionEvent evt) {
        this.updateToolBar();
    }

    public void doRefresh(boolean wait) {
        this.doRefresh(null, wait, this.showUpdated);
    }

    public void doRefresh(String message, boolean wait, boolean updated) {
        final Task refresh = this.refresh(message, updated);
        if (refresh != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(SVNAppView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    SVNApp.getApplication().getContext().getTaskService().execute(refresh);
                }
            };
            if (wait) {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InterruptedException ex) {
                }
                catch (InvocationTargetException ex) {}
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public void setLoggedIn(boolean b) {
        boolean old = this.isLoggedIn();
        if (old != b) {
            this.loggedIn = b;
            this.firePropertyChange("loggedIn", old, this.isLoggedIn());
        }
        this.loginMenuItem.setToolTipText("Currently logged in as " + this.preferences.get("username", "no one"));
    }

    public boolean isTablePopulated() {
        return this.tablePopulated;
    }

    public void setTablePopulated(boolean b) {
        boolean old = this.isTablePopulated();
        if (old != b) {
            this.tablePopulated = b;
            this.firePropertyChange("tablePopulated", old, this.isTablePopulated());
        }
    }

    public boolean isRowSelected() {
        return this.rowSelected;
    }

    public boolean isTwoRowsSelected() {
        return this.twoRowsSelected;
    }

    public boolean isCommitableSelected() {
        return this.commitableSelected;
    }

    public boolean isRevertableSelected() {
        return this.revertableSelected;
    }

    public boolean isConflictSelected() {
        return this.conflictSelected;
    }

    public boolean isAddableSelected() {
        return this.addableSelected;
    }

    public void resetButtons() {
        boolean wasSelected = this.rowSelected;
        this.rowSelected = false;
        this.twoRowsSelected = false;
        this.setRowSelected(wasSelected);
        this.jindentSettingsMenuItem.setToolTipText("Current Settings file is " + this.preferences.get("jindentSettings", "not set"));
        this.diffProgramMenuItem.setToolTipText("Current Diff program is " + this.preferences.get("diffProgram", "not set"));
        this.mergeProgramMenuItem.setToolTipText("Current Merge program is " + this.preferences.get("mergeProgram", "not set"));
    }

    public void setRowSelected(boolean b) {
        this.statusMessageLabel.setText("Selected " + this.fileListing.getSelectedRowCount() + " files");
        this.messageTimer.restart();
        int numberSelectedRows = this.fileListing.getSelectedRowCount();
        boolean old = this.isRowSelected();
        if (old != b) {
            boolean oldDiffEnabled = this.preferences.get("diffProgram", null) != null;
            this.rowSelected = b;
            this.firePropertyChange("rowSelected", old, this.isRowSelected());
            this.firePropertyChange("diffEnabled", old && oldDiffEnabled, this.rowSelected && oldDiffEnabled);
        }
        if ((old = this.isTwoRowsSelected()) != (2 == numberSelectedRows)) {
            this.twoRowsSelected = 2 == numberSelectedRows;
            this.firePropertyChange("twoRowsSelected", old, this.twoRowsSelected);
        }
        boolean commitable = false;
        boolean revertable = false;
        boolean conflict = false;
        for (int row : this.fileListing.getSelectedRows()) {
            int realRow = this.fileListing.getRowSorter().convertRowIndexToModel(row);
            FileTableRow ftr = this.model.getRow(realRow);
            if (ftr.isCommitable()) {
                if (ftr.isConflict()) {
                    conflict = true;
                }
                commitable = true;
                revertable = true;
                break;
            }
            if (!ftr.isMissing()) continue;
            revertable = true;
        }
        if (commitable != this.commitableSelected) {
            this.commitableSelected = commitable;
            this.firePropertyChange("commitableSelected", !commitable, commitable);
        }
        if (revertable != this.revertableSelected) {
            this.revertableSelected = revertable;
            this.firePropertyChange("revertableSelected", !revertable, revertable);
        }
        if (conflict != this.conflictSelected) {
            this.conflictSelected = conflict;
            this.firePropertyChange("conflictSelected", !conflict, conflict);
        }
        boolean addable = false;
        for (int row : this.fileListing.getSelectedRows()) {
            int realRow = this.fileListing.getRowSorter().convertRowIndexToModel(row);
            if (!this.model.getRow(realRow).isAddable()) continue;
            addable = true;
            break;
        }
        if (addable != this.addableSelected) {
            this.addableSelected = addable;
            this.firePropertyChange("addableSelected", !addable, addable);
        }
    }

    public boolean isDiffEnabled() {
        return this.rowSelected && this.preferences.get("diffProgram", null) != null;
    }

    public boolean isRepoEmpty() {
        String repo = this.tfRepository.getText();
        return repo == null || repo.length() == 0;
    }

    public boolean isRepoSet() {
        String repo = this.tfRepository.getText();
        return repo != null && repo.length() > 0;
    }

    public void setRepo(String string) {
        String oldString = this.tfRepository.getText();
        if (!string.equals(oldString)) {
            System.out.println("setting repo: " + string);
            boolean oldValue = oldString != null && oldString.length() > 0;
            boolean newValue = string != null && string.length() > 0;
            this.tfRepository.setText(string);
            this.firePropertyChange("repoSet", oldValue, newValue);
            this.firePropertyChange("repoEmpty", !oldValue, !newValue);
        }
    }

    public static String shortenFileName(String name, int width) {
        if (name.length() > width) {
            String[] split = name.replace('\\', '/').split("/");
            name = "";
            String prefix = "";
            String tmp = "";
            int i = 0;
            int j = split.length - 1;
            int k = 1;
            while (tmp.length() + name.length() + prefix.length() < width) {
                if (k % 2 == 0) {
                    name = tmp + name;
                    tmp = split[i++] + '/';
                } else {
                    prefix = prefix + tmp;
                    tmp = '/' + split[j--];
                }
                ++k;
            }
            name = prefix + "..." + name;
        }
        return name;
    }

    private void updateToolBar() {
        this.tbModified.setSelected(this.showChanged && this.showAdded && this.showRemoved && this.showConflicts);
        this.tbChanged.setSelected(this.showChanged);
        this.tbUpdated.setSelected(this.showUpdated);
        this.tbAdded.setSelected(this.showAdded);
        this.tbRemoved.setSelected(this.showRemoved);
        this.tbConflicts.setSelected(this.showConflicts);
        this.tbShowMissing.setSelected(this.showMissing);
        this.tbHideMissing.setSelected(this.hideMissing);
        this.tbShowUnknown.setSelected(this.showUnknown);
        this.tbHideUnknown.setSelected(this.hideUnknown);
        this.tbShowIgnored.setSelected(this.showIgnored);
        this.tbHideMissing.setEnabled(!this.showChanged && !this.showAdded && !this.showRemoved && !this.showConflicts);
        this.tbHideUnknown.setEnabled(!this.showChanged && !this.showAdded && !this.showRemoved && !this.showConflicts && !this.showMissing);
        Pattern pattern = Pattern.compile(this.tableFilter.getText(), 2);
        this.filterMatches = pattern.matcher("");
        this.fileListing.getRowSorter().allRowsChanged();
    }

    @Action
    public void showModified() {
        boolean set;
        this.showChanged = set = this.tbModified.isSelected();
        this.showAdded = set;
        this.showRemoved = set;
        this.showConflicts = set;
        this.updateToolBar();
    }

    @Action
    public void showChanged() {
        this.showChanged = this.tbChanged.isSelected();
        this.updateToolBar();
    }

    @Action
    public void showUpdated() {
        this.showUpdated = this.tbUpdated.isSelected();
        this.updateToolBar();
        this.doRefresh(false);
    }

    @Action
    public void showAdded() {
        this.showAdded = this.tbAdded.isSelected();
        this.updateToolBar();
    }

    @Action
    public void showRemoved() {
        this.showRemoved = this.tbRemoved.isSelected();
        this.updateToolBar();
    }

    @Action
    public void showConflicts() {
        this.showConflicts = this.tbConflicts.isSelected();
        this.updateToolBar();
    }

    @Action
    public void showMissing() {
        if (this.tbShowMissing.isSelected()) {
            this.showMissing = true;
            this.hideMissing = false;
        } else {
            this.showMissing = false;
        }
        this.updateToolBar();
    }

    @Action
    public void hideMissing() {
        if (this.tbHideMissing.isSelected()) {
            this.showMissing = false;
            this.hideMissing = true;
        } else {
            this.hideMissing = false;
        }
        this.updateToolBar();
    }

    @Action
    public void showUnknown() {
        if (this.tbShowUnknown.isSelected()) {
            this.showUnknown = true;
            this.hideUnknown = false;
        } else {
            this.showUnknown = false;
        }
        this.updateToolBar();
    }

    @Action
    public void hideUnknown() {
        if (this.tbHideUnknown.isSelected()) {
            this.showUnknown = false;
            this.hideUnknown = true;
        } else {
            this.hideUnknown = false;
        }
        this.updateToolBar();
    }

    @Action
    public void showIgnored() {
        this.showIgnored = this.tbShowIgnored.isSelected();
        this.updateToolBar();
    }

    @Action
    public void showBranchesInGraph() {
    }

    @Action(enabledProperty="rowSelected")
    public void remove() {
        List<FileTableRow> files = this.getSelectRows();
        if (this.askConfirm("Confirm Revert", "remove", files)) {
            for (FileTableRow row : files) {
                File file = row.getFile();
                if (file.isFile() && row.isCommitable()) {
                    File backFile = new File(file.getParentFile(), file.getName() + "~");
                    if (backFile.exists()) {
                        backFile.delete();
                    }
                    file.renameTo(backFile);
                }
                try {
                    SVNApp.getApplication().getSVNClientManager().getWCClient().doDelete(file, true, false);
                }
                catch (SVNException ex) {
                    Logger.getLogger(SVNAppView.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.doRefresh("Remove finished", false, this.showUpdated);
        }
    }

    @Action(enabledProperty="rowSelected")
    public Task history() {
        return new HistoryTask(SVNApp.getApplication(), this.getSelectRows().get(0).getLocation(), this.getSelectRows().get(0));
    }

    @Action(enabledProperty="rowSelected")
    public Task properties() {
        return new PropertiesTask(SVNApp.getApplication(), this.getSelectRows().get(0));
    }

    private SVNRevision askForRevision() {
        String revision = JOptionPane.showInputDialog(SVNApp.getApplication().getMainFrame(), "Revision Number", this.lastRevision);
        SVNRevision rev = SVNRevision.parse((String)revision);
        if (rev != SVNRevision.UNDEFINED) {
            this.lastRevision = rev;
            return rev;
        }
        if (revision != null) {
            JOptionPane.showMessageDialog(SVNApp.getApplication().getMainFrame(), "Revision " + revision + " is not valid.", "Invalid Revision", 0);
        }
        return null;
    }

    @Action(enabledProperty="rowSelected")
    public Task updateToRevision() {
        SVNRevision revision = this.askForRevision();
        if (revision != null) {
            return new UpdateTask(SVNApp.getApplication(), this.getSelectRows(), revision);
        }
        return null;
    }

    @Action(enabledProperty="rowSelected")
    public Task diffWithRevision() {
        SVNRevision revision = this.askForRevision();
        if (revision != null) {
            return new DiffTask(SVNApp.getApplication(), this.getSelectRows(), revision);
        }
        return null;
    }

    @Action(enabledProperty="twoRowsSelected")
    public Task diffSelectedFiles() {
        return new DiffTask(SVNApp.getApplication(), this.getSelectRows(), true);
    }

    @Action(block=Task.BlockingScope.APPLICATION, enabledProperty="repoSet")
    public Task copyWorkingCopy() {
        String branchName;
        String workingFolder = this.getWorkingFolder();
        if (workingFolder != null && (branchName = JOptionPane.showInputDialog(SVNApp.getApplication().getMainFrame(), "Branch Name", this.lastBranchName)) != null) {
            this.lastBranchName = branchName;
            try {
                File source = new File(workingFolder);
                SVNURL destination = this.getRootURL().appendPath("branches", false).appendPath(branchName, false);
                return new BranchTask(SVNApp.getApplication(), source, destination);
            }
            catch (SVNException ex) {
                Logger.getLogger(SVNAppView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    @Action(enabledProperty="conflictSelected")
    public Task resolveConflict() {
        List<FileTableRow> files = this.getCommitableFiles();
        return new ResolveTask(SVNApp.getApplication(), files);
    }

    @Action(enabledProperty="repoSet")
    public void repoview() {
        this.showRepoView(false, true);
    }

    private void updateTextPane(final String text, final AttributeSet attrs) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Document doc = SVNAppView.this.messageTextPane.getDocument();
                try {
                    doc.insertString(doc.getLength(), text, attrs);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                SVNAppView.this.messageTextPane.setCaretPosition(doc.getLength() - 1);
            }
        });
    }

    private void redirectSystemStreams() {
        System.setOut(new PrintStream(new ColoredOutputStream(Color.black), true));
        System.setErr(new PrintStream(new ColoredOutputStream(Color.red), true));
    }

    @Action
    public void newProject() {
        this.showChooser("New Project Folder");
    }

    @Action
    public void openProject() {
        this.showChooser("Open Project Folder");
    }

    class ColoredOutputStream
    extends OutputStream {
        SimpleAttributeSet attributes = new SimpleAttributeSet();

        public ColoredOutputStream(Color color) {
            StyleConstants.setForeground(this.attributes, color);
        }

        @Override
        public void write(int b) throws IOException {
            SVNAppView.this.updateTextPane(String.valueOf((char)b), this.attributes);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            SVNAppView.this.updateTextPane(new String(b, off, len), this.attributes);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }
    }
}

