/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn;

import java.awt.Window;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SessionStorage;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.Task;
import org.jdesktop.application.View;
import org.sdrinovsky.sdsvn.ConflictResolverHandler;
import org.sdrinovsky.sdsvn.SVNAppView;
import org.sdrinovsky.sdsvn.dialogs.LoginDialog;
import org.sdrinovsky.sdsvn.properties.ComboBoxProperty;
import org.sdrinovsky.sdsvn.properties.SelectedProperty;
import org.sdrinovsky.sdsvn.properties.TextFieldProperty;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNApp
extends SingleFrameApplication {
    SVNClientManager clientManager;
    Preferences preferences;

    protected void startup() {
        this.getContext().getSessionStorage().putProperty(JToggleButton.class, (SessionStorage.Property)new SelectedProperty());
        this.getContext().getSessionStorage().putProperty(JCheckBox.class, (SessionStorage.Property)new SelectedProperty());
        this.getContext().getSessionStorage().putProperty(JCheckBoxMenuItem.class, (SessionStorage.Property)new SelectedProperty());
        this.getContext().getSessionStorage().putProperty(JTextField.class, (SessionStorage.Property)new TextFieldProperty());
        this.getContext().getSessionStorage().putProperty(JComboBox.class, (SessionStorage.Property)new ComboBoxProperty());
        SVNAppView view = new SVNAppView(this);
        ResourceMap resourceMap = this.getContext().getResourceMap(SVNApp.class);
        this.show((View)view);
        view.fixButtons();
        view.doRefresh(false);
        this.getMainFrame().setIconImage(resourceMap.getImageIcon("Application.icon").getImage());
        if (this.getPreferences().get("username", null) == null) {
            this.show(new LoginDialog());
        }
    }

    protected void configureWindow(Window root) {
    }

    public static SVNApp getApplication() {
        return (SVNApp)Application.getInstance(SVNApp.class);
    }

    public static void main(String[] args) {
        SVNApp.launch(SVNApp.class, (String[])args);
    }

    public void executeTask(Task task) {
        this.getContext().getTaskService().execute(task);
    }

    public Preferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = Preferences.userNodeForPackage(SVNApp.class);
        }
        return this.preferences;
    }

    public SVNClientManager getSVNClientManager() {
        if (this.clientManager == null) {
            DAVRepositoryFactory.setup();
            SVNRepositoryFactoryImpl.setup();
            FSRepositoryFactory.setup();
            DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
            options.setConflictHandler((ISVNConflictHandler)new ConflictResolverHandler(this));
            String username = this.getPreferences().get("username", null);
            String password = this.getPreferences().get("password", null);
            this.clientManager = SVNClientManager.newInstance((DefaultSVNOptions)options, (String)username, (String)password);
        }
        return this.clientManager;
    }

    public void resetSVNClientManager() {
        this.clientManager = null;
    }

    public SVNInfo getFileInfo(File file) {
        try {
            return this.getSVNClientManager().getWCClient().doInfo(file, SVNRevision.WORKING);
        }
        catch (SVNException sVNException) {
            return null;
        }
    }

    public SVNURL getRootURL(File file) {
        SVNInfo info = this.getFileInfo(file);
        if (info != null) {
            return info.getRepositoryRootURL();
        }
        return null;
    }
}

