/*
 * Decompiled with CFR 0.152.
 */
package org.sdrinovsky.sdsvn;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.sdrinovsky.sdsvn.SVNApp;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNConflictHandler;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNConflictResult;
import org.tmatesoft.svn.core.wc.SVNMergeFileSet;

public class ConflictResolverHandler
implements ISVNConflictHandler {
    SVNApp app;
    JRadioButton baseButton = new JRadioButton(new ConflictAction("Base Version", SVNConflictChoice.BASE));
    JRadioButton mineConflictsButton = new JRadioButton(new ConflictAction("Mine Conflicts", SVNConflictChoice.MINE_CONFLICT));
    JRadioButton mineFullyButton = new JRadioButton(new ConflictAction("Mine Fully", SVNConflictChoice.MINE_FULL));
    JRadioButton theirsConflictsButton = new JRadioButton(new ConflictAction("Theirs Conflicts", SVNConflictChoice.THEIRS_CONFLICT));
    JRadioButton theirsFullyButton = new JRadioButton(new ConflictAction("Theirs Fully", SVNConflictChoice.THEIRS_FULL));
    JRadioButton postponeButton = new JRadioButton(new ConflictAction("Postpone", SVNConflictChoice.POSTPONE));
    ButtonGroup group = new ButtonGroup();
    JPanel choicePanel = new JPanel(new GridLayout(0, 1));
    ConflictAction selectedAction = null;

    public ConflictResolverHandler(SVNApp app) {
        this.app = app;
        this.group.add(this.baseButton);
        this.group.add(this.mineConflictsButton);
        this.group.add(this.mineFullyButton);
        this.group.add(this.theirsConflictsButton);
        this.group.add(this.theirsFullyButton);
        this.group.add(this.postponeButton);
        this.choicePanel.add(this.baseButton);
        this.choicePanel.add(this.mineConflictsButton);
        this.choicePanel.add(this.mineFullyButton);
        this.choicePanel.add(this.theirsConflictsButton);
        this.choicePanel.add(this.theirsFullyButton);
        this.choicePanel.add(this.postponeButton);
        this.postponeButton.doClick();
    }

    public SVNConflictResult handleConflict(SVNConflictDescription conflictDescription) throws SVNException {
        SVNMergeFileSet mergeFiles = conflictDescription.getMergeFiles();
        int rc = JOptionPane.showConfirmDialog(this.app.getMainFrame(), this.choicePanel, "Conflict merging " + mergeFiles.getWCPath(), 2);
        if (rc == 0 && this.selectedAction != null) {
            System.out.println("Resolving conflict for " + mergeFiles.getWCFile() + ", choosing " + this.selectedAction.getValue("Name"));
            return new SVNConflictResult(this.selectedAction.choice, mergeFiles.getResultFile());
        }
        throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CANCELLED, (String)"Merge Canceled"));
    }

    private class ConflictAction
    extends AbstractAction {
        SVNConflictChoice choice;

        public ConflictAction(String name, SVNConflictChoice choice) {
            super(name);
            this.choice = choice;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConflictResolverHandler.this.selectedAction = this;
        }
    }
}

