/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.swing.autospell;

import com.swabunga.spell.swing.autospell.AutoSpellConstants;
import com.swabunga.spell.swing.autospell.AutoSpellViewFactory;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.ViewFactory;

public class AutoSpellEditorKit
extends StyledEditorKit
implements AutoSpellConstants {
    private StyledEditorKit editorKit = null;
    private JEditorPane pane = null;

    public AutoSpellEditorKit(StyledEditorKit editorKit) {
        this.editorKit = editorKit;
    }

    public StyledEditorKit getStyledEditorKit() {
        return this.editorKit;
    }

    @Override
    public Object clone() {
        return new AutoSpellEditorKit(this.editorKit);
    }

    @Override
    public void deinstall(JEditorPane c) {
        this.editorKit.deinstall(c);
        this.pane = null;
    }

    @Override
    public Element getCharacterAttributeRun() {
        return this.editorKit.getCharacterAttributeRun();
    }

    @Override
    public MutableAttributeSet getInputAttributes() {
        return this.editorKit.getInputAttributes();
    }

    @Override
    public void install(JEditorPane c) {
        this.editorKit.install(c);
        this.pane = c;
    }

    @Override
    public String getContentType() {
        return this.editorKit.getContentType();
    }

    @Override
    public Action[] getActions() {
        Action[] actions = new Action[this.editorKit.getActions().length + 1];
        for (int i = 0; i < this.editorKit.getActions().length; ++i) {
            actions[i] = this.editorKit.getActions()[i];
        }
        actions[actions.length - 1] = new SpellCheckAction();
        return actions;
    }

    @Override
    public Caret createCaret() {
        return this.editorKit.createCaret();
    }

    @Override
    public Document createDefaultDocument() {
        return this.editorKit.createDefaultDocument();
    }

    @Override
    public ViewFactory getViewFactory() {
        return new AutoSpellViewFactory(this.editorKit.getViewFactory());
    }

    @Override
    public void read(InputStream in, Document doc, int pos) throws IOException, BadLocationException {
        this.editorKit.read(in, doc, pos);
    }

    @Override
    public void write(OutputStream out, Document doc, int pos, int len) throws IOException, BadLocationException {
        this.editorKit.write(out, doc, pos, len);
    }

    @Override
    public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        this.editorKit.read(in, doc, pos);
    }

    @Override
    public void write(Writer out, Document doc, int pos, int len) throws IOException, BadLocationException {
        this.editorKit.write(out, doc, pos, len);
    }

    private class SpellCheckAction
    extends AbstractAction {
        public SpellCheckAction() {
            super("Mark as misspelled");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int pos = AutoSpellEditorKit.this.pane.getCaretPosition();
            if (pos < 0) {
                return;
            }
            SimpleAttributeSet attr = new SimpleAttributeSet(((StyledDocument)AutoSpellEditorKit.this.pane.getDocument()).getCharacterElement(pos).getAttributes());
            attr.addAttribute("misspelled", AutoSpellConstants.wordMisspelledTrue);
            ((JTextPane)AutoSpellEditorKit.this.pane).setCharacterAttributes(attr, false);
        }
    }
}

