/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.swing.autospell;

import com.swabunga.spell.engine.Configuration;
import com.swabunga.spell.engine.Word;
import com.swabunga.spell.event.DocumentWordTokenizer;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.swing.autospell.AutoSpellConstants;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;

public class AutoSpellCheckHandler
extends MouseAdapter
implements DocumentListener,
AutoSpellConstants {
    private SpellChecker sCheck = null;
    private Configuration config = Configuration.getConfiguration();
    private ResourceBundle messages = null;
    private Map<Document, JEditorPane> doc2compMap = new HashMap<Document, JEditorPane>();

    public AutoSpellCheckHandler(SpellChecker sc) {
        this.sCheck = sc;
    }

    public AutoSpellCheckHandler(SpellChecker sc, ResourceBundle rs) {
        this(sc);
        this.messages = rs;
    }

    public void addJEditorPane(JEditorPane component) {
        StyledDocument doc = (StyledDocument)component.getDocument();
        this.markupSpelling(doc, 0, doc.getLength() - 1, -1);
        doc.addDocumentListener(this);
        component.addMouseListener(this);
        this.doc2compMap.put(doc, component);
    }

    public void removeJEditorPane(JEditorPane component) {
        Document doc = component.getDocument();
        component.removeMouseListener(this);
        doc.removeDocumentListener(this);
        this.doc2compMap.remove(doc);
    }

    private void markupSpelling(StyledDocument doc, int start, int end, int current) {
        int wordStart = -1;
        int wordEnd = -1;
        Segment seg = new Segment();
        DocumentWordTokenizer docTok = new DocumentWordTokenizer(doc);
        if (start > 0) {
            docTok.posStartFullWordFrom(start);
        }
        while (docTok.hasMoreWords() && docTok.getCurrentWordPosition() <= end) {
            String word = docTok.nextWord();
            wordStart = docTok.getCurrentWordPosition();
            if (wordEnd != -1) {
                this.markAsCorrect(doc, wordEnd, wordStart);
            }
            if ((wordEnd = docTok.getCurrentWordEnd()) > doc.getLength()) {
                wordEnd = doc.getLength() - 1;
            }
            if (wordStart >= wordEnd) continue;
            if (this.sCheck.isCorrect(word) || this.sCheck.isIgnored(word)) {
                this.markAsCorrect(doc, wordStart, wordEnd);
                continue;
            }
            if (current >= wordStart && current <= wordEnd) continue;
            this.markAsMisspelled(doc, wordStart, wordEnd);
        }
        if (wordEnd < end && wordEnd != -1) {
            if (wordStart == wordEnd - 1) {
                this.markAsCorrect(doc, wordStart, end);
            } else {
                this.markAsCorrect(doc, wordEnd, end);
            }
        }
    }

    private void markAsMisspelled(StyledDocument doc, int start, int end) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        attr.addAttribute("misspelled", wordMisspelledTrue);
        doc.setCharacterAttributes(start, end - start, attr, false);
    }

    private void markAsCorrect(StyledDocument doc, int start, int end) {
        SimpleAttributeSet attr = new SimpleAttributeSet(doc.getCharacterElement((start + end) / 2).getAttributes());
        attr.removeAttribute("misspelled");
        if (end >= start) {
            doc.setCharacterAttributes(start, end - start, attr, true);
        }
    }

    private void handleDocumentChange(DocumentEvent evt) {
        if (evt.getDocument() instanceof StyledDocument) {
            int end;
            int start;
            StyledDocument doc = (StyledDocument)evt.getDocument();
            int current = this.doc2compMap.get(doc).getCaretPosition();
            Element curElem = doc.getCharacterElement(evt.getOffset());
            Element parElem = curElem.getParentElement();
            if (parElem != null) {
                start = parElem.getStartOffset();
                end = parElem.getEndOffset();
            } else {
                start = curElem.getStartOffset();
                end = curElem.getEndOffset();
            }
            this.markupSpelling(doc, start, end, current);
        }
    }

    private void showSuggestionPopup(JEditorPane pane, Point p) {
        StyledDocument doc;
        AttributeSet attr;
        int pos = pane.viewToModel(p);
        if (pos >= 0 && (attr = (doc = (StyledDocument)pane.getDocument()).getCharacterElement(pos).getAttributes()).containsAttribute("misspelled", wordMisspelledTrue)) {
            JMenuItem item;
            DocumentWordTokenizer docTok = new DocumentWordTokenizer(doc);
            docTok.posStartFullWordFrom(pos);
            String word = docTok.nextWord();
            List suggestions = this.sCheck.getSuggestions(word, this.config.getInteger("SPELL_THRESHOLD"));
            JPopupMenu popup = new JPopupMenu();
            ReplaceListener repList = new ReplaceListener(docTok);
            for (int i = 0; i < suggestions.size(); ++i) {
                Word w = (Word)suggestions.get(i);
                item = new JMenuItem(w.getWord());
                item.setActionCommand(w.getWord());
                item.addActionListener(repList);
                popup.add(item);
            }
            popup.addSeparator();
            item = new JMenuItem();
            if (this.messages != null) {
                item.setText(this.messages.getString("IGNOREALL"));
            } else {
                item.setText("Ignore All");
            }
            item.setActionCommand(word);
            item.addActionListener(new IgnoreAllListener(doc));
            popup.add(item);
            item = new JMenuItem();
            if (this.messages != null) {
                item.setText(this.messages.getString("ADD"));
            } else {
                item.setText("Add word to wordlist");
            }
            item.setActionCommand(word);
            item.addActionListener(new AddToDictListener(doc));
            popup.add(item);
            popup.show(pane, p.x, p.y);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        SpellCheckChange r = new SpellCheckChange(evt);
        SwingUtilities.invokeLater(r);
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        SpellCheckChange r = new SpellCheckChange(evt);
        SwingUtilities.invokeLater(r);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        JEditorPane pane;
        if (!(evt.getComponent() instanceof JEditorPane)) {
            return;
        }
        if (evt.isPopupTrigger() && (pane = (JEditorPane)evt.getComponent()).isEditable()) {
            this.showSuggestionPopup(pane, new Point(evt.getX(), evt.getY()));
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        JEditorPane pane;
        if (!(evt.getComponent() instanceof JEditorPane)) {
            return;
        }
        if (evt.isPopupTrigger() && (pane = (JEditorPane)evt.getComponent()).isEditable()) {
            this.showSuggestionPopup(pane, new Point(evt.getX(), evt.getY()));
        }
    }

    private class MarkUpSpellingAll
    implements Runnable {
        private StyledDocument doc;

        public MarkUpSpellingAll(StyledDocument doc) {
            this.doc = doc;
        }

        @Override
        public void run() {
            AutoSpellCheckHandler.this.markupSpelling(this.doc, 0, this.doc.getLength(), -1);
        }
    }

    private class IgnoreAllListener
    implements ActionListener {
        private StyledDocument doc;

        public IgnoreAllListener(StyledDocument doc) {
            this.doc = doc;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AutoSpellCheckHandler.this.sCheck.ignoreAll(evt.getActionCommand());
            MarkUpSpellingAll r = new MarkUpSpellingAll(this.doc);
            SwingUtilities.invokeLater(r);
        }
    }

    private class AddToDictListener
    implements ActionListener {
        private StyledDocument doc;

        public AddToDictListener(StyledDocument doc) {
            this.doc = doc;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AutoSpellCheckHandler.this.sCheck.addToDictionary(evt.getActionCommand());
            MarkUpSpellingAll r = new MarkUpSpellingAll(this.doc);
            SwingUtilities.invokeLater(r);
        }
    }

    private class ReplaceListener
    implements ActionListener {
        DocumentWordTokenizer tok;

        public ReplaceListener(DocumentWordTokenizer tok) {
            this.tok = tok;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.tok.replaceWord(evt.getActionCommand());
        }
    }

    private class SpellCheckChange
    implements Runnable {
        private DocumentEvent evt;

        public SpellCheckChange(DocumentEvent evt) {
            this.evt = evt;
        }

        @Override
        public void run() {
            AutoSpellCheckHandler.this.handleDocumentChange(this.evt);
        }
    }
}

