/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.swing;

import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.engine.Word;
import com.swabunga.spell.swing.SpellCheckedDocument;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;

public class SpellEditorKit
extends StyledEditorKit {
    protected static final Cursor linkCursor = Cursor.getPredefinedCursor(12);
    protected Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    static SpellDictionary dictionary;

    public SpellEditorKit(File file) {
        SpellDictionaryHashMap o;
        try {
            o = new SpellDictionaryHashMap(file);
        }
        catch (Exception f) {
            o = null;
        }
        dictionary = o;
    }

    @Override
    public void install(JEditorPane c) {
        LinkController adapt = new LinkController();
        c.addMouseMotionListener(adapt);
        c.addMouseListener(adapt);
        super.install(c);
        this.defaultCursor = c.getCursor();
    }

    @Override
    public Document createDefaultDocument() {
        return new SpellCheckedDocument(dictionary);
    }

    class ReplaceListener
    implements ActionListener {
        int offset;
        int length;
        Document doc;

        public ReplaceListener(int offset, int length, Document doc) {
            this.offset = offset;
            this.length = length;
            this.doc = doc;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.doc.remove(this.offset, this.length);
                this.doc.insertString(this.offset, e.getActionCommand(), null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public class LinkController
    extends MouseAdapter
    implements MouseMotionListener {
        private Element curElem = null;
        private boolean curElemImage = false;
        private String href = null;
        private Position.Bias[] bias = new Position.Bias[1];
        private int curOffset;
        private int linkoffset = 0;

        @Override
        public void mouseClicked(MouseEvent e) {
            Point pt;
            int pos;
            if (e.isPopupTrigger()) {
                return;
            }
            JEditorPane editor = (JEditorPane)e.getSource();
            if (editor.isEditable() && (pos = editor.viewToModel(pt = new Point(e.getX(), e.getY()))) >= 0 && this.href != null) {
                SpellCheckedDocument hdoc = (SpellCheckedDocument)editor.getDocument();
                Element elem = hdoc.getCharacterElement(pos);
                try {
                    final String word = hdoc.getText(elem.getStartOffset(), elem.getEndOffset() - elem.getStartOffset());
                    List list = dictionary.getSuggestions(word, 5);
                    JPopupMenu popup = new JPopupMenu();
                    ReplaceListener listener = new ReplaceListener(elem.getStartOffset(), elem.getEndOffset() - elem.getStartOffset(), hdoc);
                    for (int index = 0; index < list.size() && index < 5; ++index) {
                        Word w = (Word)list.get(index);
                        JMenuItem item = new JMenuItem(w.getWord());
                        item.setActionCommand(w.getWord());
                        item.addActionListener(listener);
                        popup.add(item);
                    }
                    JMenuItem item = new JMenuItem("Add word to wordlist");
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            dictionary.addWord(word);
                        }
                    });
                    popup.add(item);
                    popup.show(editor, e.getX(), e.getY());
                }
                catch (BadLocationException f) {
                    System.out.println("" + elem.getStartOffset() + " count " + elem.getElementCount());
                }
            }
            this.href = null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int pos = -1;
            JEditorPane editor = (JEditorPane)e.getSource();
            boolean adjustCursor = true;
            Cursor newCursor = SpellEditorKit.this.defaultCursor;
            if (editor.isEditable()) {
                Point pt = new Point(e.getX(), e.getY());
                pos = editor.getUI().viewToModel(editor, pt, this.bias);
                if (this.bias[0] == Position.Bias.Backward && pos > 0) {
                    --pos;
                }
                if (pos >= 0 && editor.getDocument() instanceof SpellCheckedDocument) {
                    SpellCheckedDocument hdoc = (SpellCheckedDocument)editor.getDocument();
                    Element elem = hdoc.getCharacterElement(pos);
                    if (!this.doesElementContainLocation(editor, elem, pos, e.getX(), e.getY())) {
                        elem = null;
                    }
                    if (this.curElem != elem || this.curElemImage) {
                        this.curElem = elem;
                        this.curElemImage = false;
                        if (elem != null) {
                            AttributeSet a = elem.getAttributes();
                            if (a.getAttribute(StyleConstants.NameAttribute) == "errorstyle") {
                                newCursor = linkCursor;
                                this.linkoffset = elem.getStartOffset();
                                try {
                                    this.href = editor.getDocument().getText(elem.getStartOffset(), elem.getEndOffset() - elem.getStartOffset());
                                }
                                catch (BadLocationException f) {}
                            } else {
                                this.href = null;
                            }
                        }
                    } else {
                        adjustCursor = false;
                    }
                    this.curOffset = pos;
                }
            }
            if (adjustCursor && editor.getCursor() != newCursor) {
                editor.setCursor(newCursor);
            }
        }

        private boolean doesElementContainLocation(JEditorPane editor, Element e, int offset, int x, int y) {
            if (e != null && offset > 0 && e.getStartOffset() == offset) {
                try {
                    TextUI ui = editor.getUI();
                    Rectangle s1 = ui.modelToView(editor, offset, Position.Bias.Forward);
                    Rectangle r1 = s1 instanceof Rectangle ? s1 : s1.getBounds();
                    Rectangle s2 = ui.modelToView(editor, e.getEndOffset(), Position.Bias.Backward);
                    Rectangle r2 = s2 instanceof Rectangle ? s2 : s2.getBounds();
                    r1.add(r2);
                    return r1.contains(x, y);
                }
                catch (BadLocationException ble) {
                    // empty catch block
                }
            }
            return true;
        }
    }
}

