/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.swing;

import com.swabunga.spell.engine.SpellDictionary;
import java.awt.Color;
import java.util.StringTokenizer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class SpellCheckedDocument
extends DefaultStyledDocument {
    public static final String ERROR_STYLE = "errorstyle";
    Style errorstyle;
    Style normalstyle;
    static AttributeSet normal;
    int checkoffset;
    int checkend;
    String checkingline;
    static SpellDictionary dictionary;
    boolean checkspelling = false;

    public SpellCheckedDocument(SpellDictionary dictionary) {
        SpellCheckedDocument.dictionary = dictionary;
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        normal = this.addStyle("normal", def);
        this.errorstyle = this.addStyle(ERROR_STYLE, def);
        StyleConstants.setForeground(this.errorstyle, Color.red);
        StyleConstants.setUnderline(this.errorstyle, true);
    }

    public void checkSpelling() {
        if (dictionary != null) {
            int start = 0;
            int end = this.getLength();
            try {
                String text = this.getText(start, end - start);
                this.checkoffset = text.indexOf(" ");
                if (this.checkoffset == -1) {
                    return;
                }
                this.checkend = text.lastIndexOf(" ");
                if (this.checkend == -1) {
                    return;
                }
                if (this.checkoffset == this.checkend) {
                    return;
                }
                ++this.checkoffset;
                this.checkingline = text.substring(this.checkoffset, this.checkend);
                if (this.checkingline == null) {
                    return;
                }
                this.checkoffset += start;
                this.checkend += start;
                this.setCharacterAttributes(this.checkoffset, this.checkend - this.checkoffset, normal, true);
                StringTokenizer token = new StringTokenizer(this.checkingline, " ");
                while (token.hasMoreTokens()) {
                    String t2;
                    String t1;
                    String tok = token.nextToken();
                    if ((tok = this.clean(tok)).indexOf("\n") != -1) {
                        t1 = tok.substring(0, tok.indexOf("\n"));
                        t2 = tok.substring(tok.indexOf("\n") + 1);
                        if (!dictionary.isCorrect(t1)) {
                            this.setCharacterAttributes(this.checkingline.indexOf(t1) + this.checkoffset, t1.length(), this.errorstyle, false);
                        }
                        if (dictionary.isCorrect(t2)) continue;
                        this.setCharacterAttributes(this.checkingline.indexOf(t2) + this.checkoffset, t2.length(), this.errorstyle, false);
                        continue;
                    }
                    if (tok.indexOf("/") != -1) {
                        t1 = tok.substring(0, tok.indexOf("/"));
                        t2 = tok.substring(tok.indexOf("/") + 1);
                        if (!dictionary.isCorrect(t1)) {
                            this.setCharacterAttributes(this.checkingline.indexOf(t1) + this.checkoffset, t1.length(), this.errorstyle, false);
                        }
                        if (dictionary.isCorrect(t2)) continue;
                        this.setCharacterAttributes(this.checkingline.indexOf(t2) + this.checkoffset, t2.length(), this.errorstyle, false);
                        continue;
                    }
                    if (dictionary.isCorrect(tok)) continue;
                    this.setCharacterAttributes(this.checkingline.indexOf(tok) + this.checkoffset, tok.length(), this.errorstyle, false);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void setCheckSpelling(boolean check) {
        if (!this.checkspelling) {
            this.checkSpelling();
        }
        this.checkspelling = check;
    }

    @Override
    public void insertString(int offset, String string, AttributeSet a) throws BadLocationException {
        super.insertString(offset, string, normal);
        if (!this.checkspelling) {
            return;
        }
        if (dictionary != null) {
            int start = offset - 30;
            int end = offset + 30;
            if (start < 0) {
                start = 0;
            }
            if (end > this.getLength()) {
                end = this.getLength();
            }
            try {
                String text = this.getText(start, end - start);
                this.checkoffset = text.indexOf(" ");
                if (this.checkoffset == -1) {
                    return;
                }
                this.checkend = text.lastIndexOf(" ");
                if (this.checkend == -1) {
                    return;
                }
                if (this.checkoffset == this.checkend) {
                    return;
                }
                ++this.checkoffset;
                this.checkingline = text.substring(this.checkoffset, this.checkend);
                if (this.checkingline == null) {
                    return;
                }
                this.checkoffset += start;
                this.checkend += start;
                this.setCharacterAttributes(this.checkoffset, this.checkend - this.checkoffset, normal, true);
                StringTokenizer token = new StringTokenizer(this.checkingline, " ");
                while (token.hasMoreTokens()) {
                    String t2;
                    String t1;
                    String tok = token.nextToken();
                    if ((tok = this.clean(tok)).indexOf("\n") != -1) {
                        t1 = tok.substring(0, tok.indexOf("\n"));
                        t2 = tok.substring(tok.indexOf("\n") + 1);
                        if (!dictionary.isCorrect(t1)) {
                            this.setCharacterAttributes(this.checkingline.indexOf(t1) + this.checkoffset, t1.length(), this.errorstyle, false);
                        }
                        if (dictionary.isCorrect(t2)) continue;
                        this.setCharacterAttributes(this.checkingline.indexOf(t2) + this.checkoffset, t2.length(), this.errorstyle, false);
                        continue;
                    }
                    if (tok.indexOf("/") != -1) {
                        t1 = tok.substring(0, tok.indexOf("/"));
                        t2 = tok.substring(tok.indexOf("/") + 1);
                        if (!dictionary.isCorrect(t1)) {
                            this.setCharacterAttributes(this.checkingline.indexOf(t1) + this.checkoffset, t1.length(), this.errorstyle, false);
                        }
                        if (dictionary.isCorrect(t2)) continue;
                        this.setCharacterAttributes(this.checkingline.indexOf(t2) + this.checkoffset, t2.length(), this.errorstyle, false);
                        continue;
                    }
                    if (dictionary.isCorrect(tok)) continue;
                    System.out.println(tok + tok.length());
                    this.setCharacterAttributes(this.checkingline.indexOf(tok) + this.checkoffset, tok.length(), this.errorstyle, false);
                }
            }
            catch (BadLocationException f) {
                // empty catch block
            }
        }
    }

    @Override
    public void remove(int offset, int len) throws BadLocationException {
        super.remove(offset, len);
        if (!this.checkspelling) {
            return;
        }
        if (dictionary != null) {
            int start = offset - 30;
            int end = offset + 30;
            if (start < 0) {
                start = 0;
            }
            if (end > this.getLength()) {
                end = this.getLength();
            }
            try {
                String text = this.getText(start, end - start);
                this.checkoffset = text.indexOf(" ");
                if (this.checkoffset == -1) {
                    return;
                }
                this.checkend = text.lastIndexOf(" ");
                if (this.checkend == -1) {
                    return;
                }
                if (this.checkoffset == this.checkend) {
                    return;
                }
                ++this.checkoffset;
                this.checkingline = text.substring(this.checkoffset, this.checkend);
                if (this.checkingline == null) {
                    return;
                }
                this.checkoffset += start;
                this.checkend += start;
                this.setCharacterAttributes(this.checkoffset, this.checkend - this.checkoffset, normal, true);
                StringTokenizer token = new StringTokenizer(this.checkingline, " ");
                while (token.hasMoreTokens()) {
                    String tok = token.nextToken();
                    if ((tok = this.clean(tok)).indexOf("\n") != -1) {
                        String t1 = tok.substring(0, tok.indexOf("\n"));
                        String t2 = tok.substring(tok.indexOf("\n") + 1);
                        if (!dictionary.isCorrect(t1)) {
                            this.setCharacterAttributes(this.checkingline.indexOf(t1) + this.checkoffset, t1.length(), this.errorstyle, false);
                        }
                        if (dictionary.isCorrect(t2)) continue;
                        this.setCharacterAttributes(this.checkingline.indexOf(t2) + this.checkoffset, t2.length(), this.errorstyle, false);
                        continue;
                    }
                    if (dictionary.isCorrect(tok)) continue;
                    this.setCharacterAttributes(this.checkingline.indexOf(tok) + this.checkoffset, tok.length(), this.errorstyle, false);
                }
            }
            catch (BadLocationException f) {
                // empty catch block
            }
        }
    }

    public String clean(String word) {
        int index;
        char[] chars = word.toCharArray();
        for (index = chars.length - 1; !Character.isLetterOrDigit(chars[index]) && index > 0; --index) {
        }
        if ((word = word.substring(0, index + 1)).endsWith(",") || word.endsWith(";") || word.endsWith(".") || word.endsWith("\n") || word.endsWith("?") || word.endsWith("!")) {
            return word.substring(0, word.length() - 1);
        }
        chars = word.toCharArray();
        for (index = 0; !Character.isLetterOrDigit(chars[index]) && index < chars.length - 1; ++index) {
        }
        word = word.substring(index);
        return word;
    }

    public void checkSplittedWords(String divider, String line) {
    }
}

