/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.swing;

import com.swabunga.spell.engine.Word;
import com.swabunga.spell.event.SpellCheckEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JSpellForm
extends JPanel
implements ActionListener,
ListSelectionListener {
    public static final String IGNORE_CMD = "IGNORE";
    public static final String IGNOREALL_CMD = "IGNOREALL";
    public static final String ADD_CMD = "ADD";
    public static final String REPLACE_CMD = "REPLACE";
    public static final String REPLACEALL_CMD = "REPLACEALL";
    public static final String CANCEL_CMD = "CANCEL";
    private static final String SUGGESTIONS_RES = "SUGGESTIONS";
    private static final String INVALIDWORD_RES = "INVALIDWORD";
    public static final String ADDWORD_1 = "ADDWORD_1";
    public static final String ADDWORD_2 = "ADDWORD_2";
    public static final String ADDWORD_3 = "ADDWORD_3";
    private JLabel wrongWordLabel;
    protected JList suggestList;
    protected JTextField checkText;
    protected SpellCheckEvent spellEvent;
    protected EventListenerList listenerList = new EventListenerList();
    protected ResourceBundle messages = ResourceBundle.getBundle("com.swabunga.spell.swing.messages", Locale.getDefault());

    public JSpellForm() {
        this.initialiseGUI();
    }

    private static final JButton createButton(String command, String text, ActionListener listener) {
        JButton btn = new JButton(text);
        btn.setActionCommand(command);
        btn.addActionListener(listener);
        return btn;
    }

    protected JPanel makeEastPanel() {
        JPanel jPanel1 = new JPanel();
        BoxLayout layout = new BoxLayout(jPanel1, 1);
        jPanel1.setLayout(layout);
        JButton ignoreBtn = JSpellForm.createButton(IGNORE_CMD, this.messages.getString(IGNORE_CMD), this);
        ignoreBtn.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        jPanel1.add(ignoreBtn);
        JButton ignoreAllBtn = JSpellForm.createButton(IGNOREALL_CMD, this.messages.getString(IGNOREALL_CMD), this);
        ignoreAllBtn.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        jPanel1.add(ignoreAllBtn);
        JButton addBtn = JSpellForm.createButton(ADD_CMD, this.messages.getString(ADD_CMD), this);
        addBtn.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        jPanel1.add(addBtn);
        JButton changeBtn = JSpellForm.createButton(REPLACE_CMD, this.messages.getString(REPLACE_CMD), this);
        changeBtn.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        jPanel1.add(changeBtn);
        JButton changeAllBtn = JSpellForm.createButton(REPLACEALL_CMD, this.messages.getString(REPLACEALL_CMD), this);
        changeAllBtn.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        jPanel1.add(changeAllBtn);
        JButton cancelBtn = JSpellForm.createButton(CANCEL_CMD, this.messages.getString(CANCEL_CMD), this);
        cancelBtn.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        jPanel1.add(cancelBtn);
        return jPanel1;
    }

    protected JPanel makeCentrePanel() {
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        JLabel lbl1 = new JLabel(this.messages.getString(INVALIDWORD_RES));
        this.wrongWordLabel = new JLabel("");
        this.wrongWordLabel.setForeground(Color.red);
        jPanel3.add(lbl1);
        jPanel3.add(this.wrongWordLabel);
        jPanel2.add(jPanel3);
        this.checkText = new JTextField();
        jPanel2.add(this.checkText);
        JLabel lbl2 = new JLabel(this.messages.getString(SUGGESTIONS_RES));
        jPanel2.add(lbl2);
        this.suggestList = new JList();
        this.suggestList.setSelectionMode(0);
        jPanel2.add(new JScrollPane(this.suggestList));
        this.suggestList.addListSelectionListener(this);
        return jPanel2;
    }

    protected void initialiseGUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.makeEastPanel(), "East");
        this.add((Component)this.makeCentrePanel(), "Center");
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionEvent(ActionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    public void setSpellEvent(SpellCheckEvent event) {
        this.spellEvent = event;
        DefaultListModel m = new DefaultListModel();
        List suggestions = event.getSuggestions();
        for (int i = 0; i < suggestions.size(); ++i) {
            m.addElement(suggestions.get(i));
        }
        this.suggestList.setModel(m);
        this.wrongWordLabel.setText(event.getInvalidWord());
        if (m.size() > 0) {
            this.suggestList.setSelectedIndex(0);
            this.checkText.setText(((Word)m.get(0)).getWord());
        } else {
            this.checkText.setText(event.getInvalidWord());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object selectedValue;
        if (!e.getValueIsAdjusting() && (selectedValue = this.suggestList.getSelectedValue()) != null) {
            this.checkText.setText(selectedValue.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (IGNORE_CMD.equals(e.getActionCommand())) {
            this.spellEvent.ignoreWord(false);
        } else if (IGNOREALL_CMD.equals(e.getActionCommand())) {
            this.spellEvent.ignoreWord(true);
        } else if (REPLACE_CMD.equals(e.getActionCommand())) {
            this.spellEvent.replaceWord(this.checkText.getText(), false);
        } else if (REPLACEALL_CMD.equals(e.getActionCommand())) {
            this.spellEvent.replaceWord(this.checkText.getText(), true);
        } else if (ADD_CMD.equals(e.getActionCommand())) {
            String inField = this.checkText.getText();
            Object selObj = this.suggestList.getSelectedValue();
            String selected = selObj == null ? "" : selObj.toString();
            String addString = inField.equals(selected) ? this.spellEvent.getInvalidWord() : inField;
            int n = JOptionPane.showConfirmDialog(this, this.messages.getString(ADDWORD_1) + " '" + addString + "' " + this.messages.getString(ADDWORD_2), this.messages.getString(ADDWORD_3), 0);
            if (n != 0) return;
            this.spellEvent.addToDictionary(addString);
        } else if (CANCEL_CMD.equals(e.getActionCommand())) {
            this.spellEvent.cancel();
        }
        this.fireActionEvent(e);
    }

    public static void main(String[] args) {
        try {
            JSpellForm pane = new JSpellForm();
            JFrame frm = new JFrame("Spelling");
            frm.getContentPane().add(pane);
            frm.setSize(300, 300);
            frm.setVisible(true);
            frm.setDefaultCloseOperation(3);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

