/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.swing;

import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.swing.JTextComponentSpellChecker;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipInputStream;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JTextArea;

public class JSpellApplet
extends JApplet {
    private static final String dictionaryFile = "dict/english.0.zip";
    private SpellDictionary dictionary;
    JTextArea text = null;
    JButton spell = null;

    @Override
    public void paint(Graphics arg0) {
        super.paint(arg0);
    }

    @Override
    public void init() {
        super.init();
        try {
            URL resource = null;
            ZipInputStream zip = null;
            try {
                resource = new URL(this.getCodeBase().toExternalForm() + dictionaryFile);
                zip = new ZipInputStream(resource.openStream());
            }
            catch (NullPointerException e) {
                FileInputStream fin = new FileInputStream(dictionaryFile);
                zip = new ZipInputStream(fin);
            }
            zip.getNextEntry();
            this.dictionary = new SpellDictionaryHashMap(new BufferedReader(new InputStreamReader(zip)));
            this.initGUI();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initGUI() {
        Container frame = this.getContentPane();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        frame.setLayout(gridbag);
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.text = new JTextArea("The quck brwn dog jmped over the fnce.");
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(true);
        this.addToFrame(frame, this.text, gridbag, c, 0, 0, 1, 1);
        GridBagConstraints spellcon = new GridBagConstraints();
        spellcon.anchor = 11;
        spellcon.insets = new Insets(5, 5, 5, 5);
        this.spell = new JButton("spell check");
        final JTextComponentSpellChecker sc = new JTextComponentSpellChecker(this.dictionary);
        this.spell.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        try {
                            sc.spellCheck(JSpellApplet.this.text);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                };
                t.start();
            }
        });
        this.addToFrame(frame, this.spell, gridbag, spellcon, 1, 0, 1, 1);
    }

    private void addToFrame(Container f, Component c, GridBagLayout gbl, GridBagConstraints gbc, int x, int y, int w, int h) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbl.setConstraints(c, gbc);
        f.add(c);
    }
}

