/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.examples;

import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.swing.JTextComponentSpellChecker;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class TextPaneMarkingExample
extends JFrame {
    private static final String englishDictionary = "dict/dict.sv";
    private static final String englishPhonetic = "dict/phonet.sv";
    protected SpellDictionary dictionary;
    JTextPane text = null;
    JButton spell = null;
    JTextComponentSpellChecker sc = null;

    public TextPaneMarkingExample(String dictPath, String phonetPath) {
        File dictFile = null;
        File phonetFile = null;
        dictFile = dictPath == null ? new File(englishDictionary) : new File(dictPath);
        if (phonetPath != null) {
            phonetFile = new File(phonetPath);
        }
        try {
            this.dictionary = new SpellDictionaryHashMap(dictFile, phonetFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                System.exit(0);
            }
        });
        this.initGUI();
        this.pack();
    }

    private void initGUI() {
        Container frame = this.getContentPane();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        frame.setLayout(gridbag);
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.text = new JTextPane();
        this.text.setPreferredSize(new Dimension(300, 150));
        this.sc = new JTextComponentSpellChecker(this.dictionary);
        this.sc.startAutoSpellCheck(this.text);
        this.addToFrame(frame, new JScrollPane(this.text), gridbag, c, 0, 1, 1, 1);
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = null;
        int menuCount = 0;
        Action[] actions = this.text.getEditorKit().getActions();
        for (int i = 0; i < actions.length; ++i) {
            if (i % 20 == 0) {
                menu = new JMenu("Actions " + menuCount);
                ++menuCount;
                menuBar.add(menu);
            }
            menu.add(actions[i]);
        }
        this.setJMenuBar(menuBar);
    }

    private void addToFrame(Container f, Component c, GridBagLayout gbl, GridBagConstraints gbc, int x, int y, int w, int h) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbl.setConstraints(c, gbc);
        f.add(c);
    }

    public static void main(String[] args) {
        String dictPath = null;
        String phonetPath = null;
        if (args.length > 0) {
            dictPath = args[0];
        }
        if (args.length > 1) {
            phonetPath = args[1];
        }
        TextPaneMarkingExample d = new TextPaneMarkingExample(dictPath, phonetPath);
        d.show();
    }
}

