/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.examples;

import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.swing.JTextComponentSpellChecker;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class JTextComponentSpellCheckExample
extends JFrame {
    private static final String englishDictionary = "dict/english.0";
    private static final String englishPhonetic = "dict/phonet.en";
    protected SpellDictionary dictionary;
    JTextComponent text = null;
    JButton spell = null;

    public JTextComponentSpellCheckExample(String dictPath, String phonetPath) {
        File dictFile = null;
        File phonetFile = null;
        dictFile = dictPath == null ? new File(englishDictionary) : new File(dictPath);
        if (phonetPath != null) {
            phonetFile = new File(phonetPath);
        }
        try {
            this.dictionary = new SpellDictionaryHashMap(dictFile, phonetFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                System.exit(0);
            }
        });
        this.initGUI();
        this.pack();
    }

    private void initGUI() {
        Container frame = this.getContentPane();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        frame.setLayout(gridbag);
        c.anchor = 10;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.text = new JTextArea(10, 40);
        this.addToFrame(frame, this.text, gridbag, c, 0, 0, 1, 1);
        this.spell = new JButton("spell");
        this.spell.addActionListener(new ButtonListener());
        this.addToFrame(frame, this.spell, gridbag, c, 0, 1, 1, 1);
    }

    private void addToFrame(Container f, Component c, GridBagLayout gbl, GridBagConstraints gbc, int x, int y, int w, int h) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbl.setConstraints(c, gbc);
        f.add(c);
    }

    public static void main(String[] args) {
        String dictPath = null;
        String phonetPath = null;
        if (args.length > 0) {
            dictPath = args[0];
        }
        if (args.length > 1) {
            phonetPath = args[1];
        }
        JTextComponentSpellCheckExample d = new JTextComponentSpellCheckExample(dictPath, phonetPath);
        d.show();
    }

    private class SpellThread
    extends Thread {
        private SpellThread() {
        }

        @Override
        public void run() {
            try {
                JTextComponentSpellChecker sc = new JTextComponentSpellChecker(JTextComponentSpellCheckExample.this.dictionary);
                sc.spellCheck(JTextComponentSpellCheckExample.this.text);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SpellThread t = new SpellThread();
            t.start();
        }
    }
}

