/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.event;

import com.swabunga.spell.engine.Configuration;
import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.engine.Word;
import com.swabunga.spell.event.BasicSpellCheckEvent;
import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.StringWordTokenizer;
import com.swabunga.spell.event.WordTokenizer;
import com.swabunga.util.VectorUtility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class SpellChecker {
    public static final int SPELLCHECK_OK = -1;
    public static final int SPELLCHECK_CANCEL = -2;
    private Vector eventListeners = new Vector();
    private Vector dictionaries = new Vector();
    private SpellDictionary userdictionary;
    private Configuration config = Configuration.getConfiguration();
    private Vector ignoredWords = new Vector();
    private Hashtable autoReplaceWords = new Hashtable();
    private Map cache;
    private int threshold = 0;
    private int cacheSize = 0;

    public SpellChecker() {
        try {
            this.userdictionary = new SpellDictionaryHashMap();
        }
        catch (IOException e) {
            throw new RuntimeException("this exception should never happen because we are using null phonetic file");
        }
    }

    public SpellChecker(SpellDictionary dictionary) {
        this();
        this.addDictionary(dictionary);
    }

    public SpellChecker(SpellDictionary dictionary, int threshold) {
        this(dictionary);
        this.config.setInteger("SPELL_THRESHOLD", threshold);
    }

    public void addDictionary(SpellDictionary dictionary) {
        if (dictionary == null) {
            throw new IllegalArgumentException("dictionary must be non-null");
        }
        this.dictionaries.addElement(dictionary);
    }

    public void setUserDictionary(SpellDictionary dictionary) {
        this.userdictionary = dictionary;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void addSpellCheckListener(SpellCheckListener listener) {
        this.eventListeners.addElement(listener);
    }

    public void removeSpellCheckListener(SpellCheckListener listener) {
        this.eventListeners.removeElement(listener);
    }

    protected void fireSpellCheckEvent(SpellCheckEvent event) {
        for (int i = this.eventListeners.size() - 1; i >= 0; --i) {
            ((SpellCheckListener)this.eventListeners.elementAt(i)).spellingError(event);
        }
    }

    public void reset() {
        this.ignoredWords = new Vector();
        this.autoReplaceWords = new Hashtable();
    }

    public String checkString(String text) {
        StringWordTokenizer tokens = new StringWordTokenizer(text);
        this.checkSpelling(tokens);
        return tokens.getContext();
    }

    private static final boolean isDigitWord(String word) {
        for (int i = word.length() - 1; i >= 0; --i) {
            if (!Character.isDigit(word.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static final boolean isINETWord(String word) {
        String lowerCaseWord = word.toLowerCase();
        return lowerCaseWord.startsWith("http://") || lowerCaseWord.startsWith("www.") || lowerCaseWord.startsWith("ftp://") || lowerCaseWord.startsWith("https://") || lowerCaseWord.startsWith("ftps://");
    }

    private static final boolean isUpperCaseWord(String word) {
        for (int i = word.length() - 1; i >= 0; --i) {
            if (!Character.isLowerCase(word.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static final boolean isMixedCaseWord(String word, boolean startsSentence) {
        int strLen = word.length();
        boolean isUpper = Character.isUpperCase(word.charAt(0));
        if (startsSentence && isUpper && strLen > 1) {
            isUpper = Character.isUpperCase(word.charAt(1));
        }
        if (isUpper) {
            for (int i = word.length() - 1; i > 0; --i) {
                if (!Character.isLowerCase(word.charAt(i))) continue;
                return true;
            }
        } else {
            for (int i = word.length() - 1; i > 0; --i) {
                if (!Character.isUpperCase(word.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean fireAndHandleEvent(WordTokenizer tokenizer, SpellCheckEvent event) {
        this.fireSpellCheckEvent(event);
        String word = event.getInvalidWord();
        switch (event.getAction()) {
            case -1: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                this.ignoreAll(word);
                break;
            }
            case 2: {
                tokenizer.replaceWord(event.getReplaceWord());
                break;
            }
            case 3: {
                String replaceAllWord = event.getReplaceWord();
                if (!this.autoReplaceWords.containsKey(word)) {
                    this.autoReplaceWords.put(word, replaceAllWord);
                }
                tokenizer.replaceWord(replaceAllWord);
                break;
            }
            case 4: {
                String addWord = event.getReplaceWord();
                if (!addWord.equals(word)) {
                    tokenizer.replaceWord(addWord);
                }
                this.userdictionary.addWord(addWord);
                break;
            }
            case 5: {
                return true;
            }
            default: {
                throw new IllegalArgumentException("Unhandled case.");
            }
        }
        return false;
    }

    public void ignoreAll(String word) {
        if (!this.ignoredWords.contains(word)) {
            this.ignoredWords.addElement(word);
        }
    }

    public void addToDictionary(String word) {
        if (!this.userdictionary.isCorrect(word)) {
            this.userdictionary.addWord(word);
        }
    }

    public boolean isIgnored(String word) {
        if (this.ignoredWords.contains(word)) {
            return true;
        }
        for (int i = word.length() - 1; i >= 0; --i) {
            if (!Character.isDigit(word.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public boolean isCorrect(String word) {
        if (this.userdictionary.isCorrect(word)) {
            return true;
        }
        Enumeration e = this.dictionaries.elements();
        while (e.hasMoreElements()) {
            SpellDictionary dictionary = (SpellDictionary)e.nextElement();
            if (!dictionary.isCorrect(word)) continue;
            return true;
        }
        return false;
    }

    public List getSuggestions(String word, int threshold) {
        if (this.threshold != threshold && this.cache != null) {
            this.threshold = threshold;
            this.cache.clear();
        }
        ArrayList suggestions = null;
        if (this.cache != null) {
            suggestions = (ArrayList)this.cache.get(word);
        }
        if (suggestions == null) {
            suggestions = new ArrayList(50);
            Enumeration e = this.dictionaries.elements();
            while (e.hasMoreElements()) {
                SpellDictionary dictionary = (SpellDictionary)e.nextElement();
                if (dictionary == this.userdictionary) continue;
                VectorUtility.addAll(suggestions, dictionary.getSuggestions(word, threshold), false);
            }
            if (this.cache != null && this.cache.size() < this.cacheSize) {
                this.cache.put(word, suggestions);
            }
        }
        VectorUtility.addAll(suggestions, this.userdictionary.getSuggestions(word, threshold), false);
        suggestions.trimToSize();
        return suggestions;
    }

    public void setCache() {
        this.setCache(300);
    }

    public void setCache(int size) {
        this.cacheSize = size;
        this.cache = size == 0 ? null : new HashMap((size + 2) / 3 * 4);
    }

    public final int checkSpelling(WordTokenizer tokenizer) {
        int errors = 0;
        boolean terminated = false;
        while (tokenizer.hasMoreWords() && !terminated) {
            String word = tokenizer.nextWord();
            if (!this.isCorrect(word)) {
                if (this.config.getBoolean("SPELL_IGNOREMIXEDCASE") && SpellChecker.isMixedCaseWord(word, tokenizer.isNewSentence()) || this.config.getBoolean("SPELL_IGNOREUPPERCASE") && SpellChecker.isUpperCaseWord(word) || this.config.getBoolean("SPELL_IGNOREDIGITWORDS") && SpellChecker.isDigitWord(word) || this.config.getBoolean("SPELL_IGNOREINTERNETADDRESS") && SpellChecker.isINETWord(word) || this.isIgnored(word)) continue;
                ++errors;
                if (this.autoReplaceWords.containsKey(word)) {
                    tokenizer.replaceWord((String)this.autoReplaceWords.get(word));
                    continue;
                }
                List suggestions = this.getSuggestions(word, this.config.getInteger("SPELL_THRESHOLD"));
                if (this.capitalizeSuggestions(word, tokenizer)) {
                    suggestions = this.makeSuggestionsCapitalized(suggestions);
                }
                BasicSpellCheckEvent event = new BasicSpellCheckEvent(word, suggestions, tokenizer);
                terminated = this.fireAndHandleEvent(tokenizer, event);
                continue;
            }
            if (!this.isSupposedToBeCapitalized(word, tokenizer)) continue;
            ++errors;
            StringBuffer buf = new StringBuffer(word);
            buf.setCharAt(0, Character.toUpperCase(word.charAt(0)));
            Vector<Word> suggestion = new Vector<Word>();
            suggestion.addElement(new Word(buf.toString(), 0));
            BasicSpellCheckEvent event = new BasicSpellCheckEvent(word, suggestion, tokenizer);
            terminated = this.fireAndHandleEvent(tokenizer, event);
        }
        if (terminated) {
            return -2;
        }
        if (errors == 0) {
            return -1;
        }
        return errors;
    }

    private List makeSuggestionsCapitalized(List suggestions) {
        for (Word word : suggestions) {
            String suggestion = word.getWord();
            StringBuffer stringBuffer = new StringBuffer(suggestion);
            stringBuffer.setCharAt(0, Character.toUpperCase(suggestion.charAt(0)));
            word.setWord(stringBuffer.toString());
        }
        return suggestions;
    }

    private boolean isSupposedToBeCapitalized(String word, WordTokenizer wordTokenizer) {
        boolean configCapitalize = !this.config.getBoolean("SPELL_IGNORESENTENCECAPTILIZATION");
        return configCapitalize && wordTokenizer.isNewSentence() && Character.isLowerCase(word.charAt(0));
    }

    private boolean capitalizeSuggestions(String word, WordTokenizer wordTokenizer) {
        boolean configCapitalize = !this.config.getBoolean("SPELL_IGNORESENTENCECAPTILIZATION");
        boolean uppercase = Character.isUpperCase(word.charAt(0));
        return configCapitalize && wordTokenizer.isNewSentence() || !configCapitalize && uppercase;
    }
}

