/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.engine;

import com.swabunga.spell.engine.SpellDictionaryASpell;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class SpellDictionaryDisk
extends SpellDictionaryASpell {
    private static final String DIRECTORY_WORDS = "words";
    private static final String DIRECTORY_DB = "db";
    private static final String FILE_CONTENTS = "contents";
    private static final String FILE_DB = "words.db";
    private static final String FILE_INDEX = "words.idx";
    private static final int INDEX_SIZE_MAX = 200;
    private File base;
    private File words;
    private File db;
    private Map index;
    protected boolean ready = false;
    private List indexCodeCache = null;

    public SpellDictionaryDisk(File base, File phonetic, boolean block) throws FileNotFoundException, IOException {
        super(phonetic);
        this.base = base;
        this.words = new File(base, DIRECTORY_WORDS);
        this.db = new File(base, DIRECTORY_DB);
        if (!this.base.exists()) {
            throw new FileNotFoundException("Couldn't find required path '" + this.base + "'");
        }
        if (!this.words.exists()) {
            throw new FileNotFoundException("Couldn't find required path '" + this.words + "'");
        }
        if (!this.db.exists()) {
            this.db.mkdirs();
        }
        if (this.newDictionaryFiles()) {
            if (block) {
                this.buildNewDictionaryDatabase();
                this.loadIndex();
                this.ready = true;
            } else {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        try {
                            SpellDictionaryDisk.this.buildNewDictionaryDatabase();
                            SpellDictionaryDisk.this.loadIndex();
                            SpellDictionaryDisk.this.ready = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                t.start();
            }
        } else {
            this.loadIndex();
            this.ready = true;
        }
    }

    protected void buildNewDictionaryDatabase() throws FileNotFoundException, IOException {
        File sortedFile = this.buildSortedFile();
        this.buildCodeDb(sortedFile);
        sortedFile.delete();
        this.buildContentsFile();
    }

    @Override
    public void addWord(String word) {
        throw new UnsupportedOperationException("addWord not yet implemented (sorry)");
    }

    @Override
    public List getWords(String code) {
        Vector<String> words = new Vector<String>();
        int[] posLen = this.getStartPosAndLen(code);
        if (posLen != null) {
            try {
                FileInputStream input = new FileInputStream(new File(this.db, FILE_DB));
                ((InputStream)input).skip(posLen[0]);
                byte[] bytes = new byte[posLen[1]];
                ((InputStream)input).read(bytes, 0, posLen[1]);
                ((InputStream)input).close();
                String data = new String(bytes);
                String[] lines = SpellDictionaryDisk.split(data, "\n");
                for (int i = 0; i < lines.length; ++i) {
                    String[] s = SpellDictionaryDisk.split(lines[i], ",");
                    if (!s[0].equals(code)) continue;
                    words.addElement(s[1]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return words;
    }

    public boolean isReady() {
        return this.ready;
    }

    private boolean newDictionaryFiles() throws FileNotFoundException, IOException {
        ArrayList<FileSize> contents = new ArrayList<FileSize>();
        File c = new File(this.db, FILE_CONTENTS);
        if (c.exists()) {
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(c));
                while ((line = reader.readLine()) != null) {
                    String[] s = SpellDictionaryDisk.split(line, ",");
                    contents.add(new FileSize(s[0], Integer.parseInt(s[1])));
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        boolean changed = false;
        File[] wordFiles = this.words.listFiles();
        if (contents.size() != wordFiles.length) {
            changed = true;
        } else {
            for (int i = 0; i < wordFiles.length; ++i) {
                FileSize fs = new FileSize(wordFiles[i].getName(), wordFiles[i].length());
                if (contents.contains(fs)) continue;
                changed = true;
                break;
            }
        }
        return changed;
    }

    private File buildSortedFile() throws FileNotFoundException, IOException {
        ArrayList<String> w = new ArrayList<String>();
        File[] wordFiles = this.words.listFiles();
        for (int i = 0; i < wordFiles.length; ++i) {
            String word;
            BufferedReader r = new BufferedReader(new FileReader(wordFiles[i]));
            while ((word = r.readLine()) != null) {
                if (word.equals("")) continue;
                w.add(word.trim());
            }
            r.close();
        }
        Collections.sort(w);
        File file = File.createTempFile("jazzy", "sorted");
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        String prev = null;
        for (int i = 0; i < w.size(); ++i) {
            String word = (String)w.get(i);
            if (prev == null || !prev.equals(word)) {
                writer.write(word);
                writer.newLine();
            }
            prev = word;
        }
        writer.close();
        return file;
    }

    private void buildCodeDb(File sortedWords) throws FileNotFoundException, IOException {
        String word;
        ArrayList<CodeWord> codeList = new ArrayList<CodeWord>();
        BufferedReader reader = new BufferedReader(new FileReader(sortedWords));
        while ((word = reader.readLine()) != null) {
            codeList.add(new CodeWord(this.getCode(word), word));
        }
        reader.close();
        Collections.sort(codeList);
        ArrayList<Object[]> index = new ArrayList<Object[]>();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(this.db, FILE_DB)));
        String currentCode = null;
        int currentPosition = 0;
        int currentLength = 0;
        for (int i = 0; i < codeList.size(); ++i) {
            CodeWord cw = (CodeWord)codeList.get(i);
            String thisCode = cw.getCode();
            thisCode = this.getIndexCode(thisCode, codeList);
            String toWrite = cw.getCode() + "," + cw.getWord() + "\n";
            byte[] bytes = toWrite.getBytes();
            if (currentCode == null) {
                currentCode = thisCode;
            }
            if (!currentCode.equals(thisCode)) {
                index.add(new Object[]{currentCode, new int[]{currentPosition, currentLength}});
                currentPosition += currentLength;
                currentLength = bytes.length;
                currentCode = thisCode;
            } else {
                currentLength += bytes.length;
            }
            out.write(bytes);
        }
        out.close();
        if (currentCode != null && currentPosition != 0 && currentLength != 0) {
            index.add(new Object[]{currentCode, new int[]{currentPosition, currentLength}});
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.db, FILE_INDEX)));
        for (int i = 0; i < index.size(); ++i) {
            Object[] o = (Object[])index.get(i);
            writer.write(o[0].toString());
            writer.write(",");
            writer.write(String.valueOf(((int[])o[1])[0]));
            writer.write(",");
            writer.write(String.valueOf(((int[])o[1])[1]));
            writer.newLine();
        }
        writer.close();
    }

    private void buildContentsFile() throws IOException {
        File[] wordFiles = this.words.listFiles();
        if (wordFiles.length > 0) {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(this.db, FILE_CONTENTS)));
            for (int i = 0; i < wordFiles.length; ++i) {
                writer.write(wordFiles[i].getName());
                writer.write(",");
                writer.write(String.valueOf(wordFiles[i].length()));
                writer.newLine();
            }
            writer.close();
        } else {
            new File(this.db, FILE_CONTENTS).delete();
        }
    }

    protected void loadIndex() throws IOException {
        String line;
        this.index = new HashMap();
        File idx = new File(this.db, FILE_INDEX);
        BufferedReader reader = new BufferedReader(new FileReader(idx));
        while ((line = reader.readLine()) != null) {
            String[] fields = SpellDictionaryDisk.split(line, ",");
            this.index.put(fields[0], new int[]{Integer.parseInt(fields[1]), Integer.parseInt(fields[2])});
        }
        reader.close();
    }

    private int[] getStartPosAndLen(String code) {
        while (code.length() > 0) {
            int[] posLen = (int[])this.index.get(code);
            if (posLen == null) {
                code = code.substring(0, code.length() - 1);
                continue;
            }
            return posLen;
        }
        return null;
    }

    private String getIndexCode(String code, List codes) {
        String newCode;
        if (this.indexCodeCache == null) {
            this.indexCodeCache = new ArrayList();
        }
        if (code.length() <= 1) {
            return code;
        }
        for (int i = 0; i < this.indexCodeCache.size(); ++i) {
            String c = (String)this.indexCodeCache.get(i);
            if (!code.startsWith(c)) continue;
            return c;
        }
        int foundSize = -1;
        boolean cacheable = false;
        for (int z = 1; z < code.length(); ++z) {
            String thisCode = code.substring(0, z);
            int count = 0;
            for (int i = 0; i < codes.size(); ++i) {
                CodeWord cw;
                if (i == 0 && (i = Collections.binarySearch(codes, new CodeWord(thisCode, ""))) < 0) {
                    i = 0;
                }
                if ((cw = (CodeWord)codes.get(i)).getCode().startsWith(thisCode) ? ++count > 200 : cw.getCode().compareTo(thisCode) > 0) break;
            }
            if (count > 200) continue;
            cacheable = true;
            foundSize = z;
            break;
        }
        String string = newCode = foundSize == -1 ? code : code.substring(0, foundSize);
        if (cacheable) {
            this.indexCodeCache.add(newCode);
        }
        return newCode;
    }

    private static String[] split(String input, String delimiter) {
        StringTokenizer st = new StringTokenizer(input, delimiter);
        int count = st.countTokens();
        String[] out = new String[count];
        for (int i = 0; i < count; ++i) {
            out[i] = st.nextToken();
        }
        return out;
    }

    private class FileSize {
        private String filename;
        private long size;

        public FileSize(String filename, long size) {
            this.filename = filename;
            this.size = size;
        }

        public String getFilename() {
            return this.filename;
        }

        public long getSize() {
            return this.size;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileSize)) {
                return false;
            }
            FileSize fileSize = (FileSize)o;
            if (this.size != fileSize.size) {
                return false;
            }
            return this.filename.equals(fileSize.filename);
        }

        public int hashCode() {
            int result = this.filename.hashCode();
            result = (int)((long)(29 * result) + this.size);
            return result;
        }
    }

    private class CodeWord
    implements Comparable {
        private String code;
        private String word;

        public CodeWord(String code, String word) {
            this.code = code;
            this.word = word;
        }

        public String getCode() {
            return this.code;
        }

        public String getWord() {
            return this.word;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CodeWord)) {
                return false;
            }
            CodeWord codeWord = (CodeWord)o;
            return this.word.equals(codeWord.word);
        }

        public int hashCode() {
            return this.word.hashCode();
        }

        public int compareTo(Object o) {
            return this.code.compareTo(((CodeWord)o).getCode());
        }
    }
}

