/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.engine;

import com.swabunga.spell.engine.Configuration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class PropertyConfiguration
extends Configuration {
    public Properties prop = new Properties();
    public URL filename;

    public PropertyConfiguration() {
        try {
            this.filename = this.getClass().getClassLoader().getResource("com/swabunga/spell/engine/configuration.properties");
            InputStream in = this.filename.openStream();
            this.prop.load(in);
        }
        catch (Exception e) {
            System.out.println("Could not load Properties file :\n" + e);
        }
    }

    @Override
    public boolean getBoolean(String key) {
        return new Boolean(this.prop.getProperty(key));
    }

    @Override
    public int getInteger(String key) {
        return new Integer(this.prop.getProperty(key));
    }

    @Override
    public void setBoolean(String key, boolean value) {
        String string = null;
        string = value ? "true" : "false";
        this.prop.setProperty(key, string);
        this.save();
    }

    @Override
    public void setInteger(String key, int value) {
        this.prop.setProperty(key, Integer.toString(value));
        this.save();
    }

    public void save() {
        try {
            File file = new File(this.filename.getFile());
            FileOutputStream fout = new FileOutputStream(file);
            this.prop.store(fout, "HEADER");
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

