/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.engine;

import com.swabunga.spell.engine.Configuration;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class EditDistance {
    public static Configuration config = Configuration.getConfiguration();
    static final int costOfDeletingSourceCharacter = config.getInteger("EDIT_DEL1");
    static final int costOfInsertingSourceCharacter = config.getInteger("EDIT_DEL2");
    static final int costOfSubstitutingLetters = config.getInteger("EDIT_SUB");
    static final int costOfSwappingLetters = config.getInteger("EDIT_SWAP");
    static final int costOfChangingCase = config.getInteger("EDIT_CASE");

    public static final int getDistance(String word, String similar) {
        return EditDistance.getDistance(word, similar, null);
    }

    public static final int getDistance(String word, String similar, int[][] matrix) {
        int j;
        int i;
        char sourceChar = '\u0000';
        char otherChar = '\u0000';
        int a_size = word.length() + 1;
        int b_size = similar.length() + 1;
        if (matrix == null || matrix.length < a_size || matrix[0].length < b_size) {
            matrix = new int[a_size][b_size];
        }
        matrix[0][0] = 0;
        for (i = 1; i != a_size; ++i) {
            matrix[i][0] = matrix[i - 1][0] + costOfInsertingSourceCharacter;
        }
        for (j = 1; j != b_size; ++j) {
            matrix[0][j] = matrix[0][j - 1] + costOfDeletingSourceCharacter;
        }
        for (i = 1; i != a_size; ++i) {
            sourceChar = word.charAt(i - 1);
            for (j = 1; j != b_size; ++j) {
                boolean isSwap;
                otherChar = similar.charAt(j - 1);
                if (sourceChar == otherChar) {
                    matrix[i][j] = matrix[i - 1][j - 1];
                    continue;
                }
                int costOfSubst = costOfSubstitutingLetters + matrix[i - 1][j - 1];
                int costOfSwap = Integer.MAX_VALUE;
                boolean bl = isSwap = i != 1 && j != 1 && sourceChar == similar.charAt(j - 2) && word.charAt(i - 2) == otherChar;
                if (isSwap) {
                    costOfSwap = costOfSwappingLetters + matrix[i - 2][j - 2];
                }
                int costOfDelete = costOfDeletingSourceCharacter + matrix[i][j - 1];
                int costOfInsertion = costOfInsertingSourceCharacter + matrix[i - 1][j];
                int costOfCaseChange = Integer.MAX_VALUE;
                if (EditDistance.equalIgnoreCase(sourceChar, otherChar)) {
                    costOfCaseChange = costOfChangingCase + matrix[i - 1][j - 1];
                }
                matrix[i][j] = EditDistance.minimum(costOfSubst, costOfSwap, costOfDelete, costOfInsertion, costOfCaseChange);
            }
        }
        return matrix[a_size - 1][b_size - 1];
    }

    private static boolean equalIgnoreCase(char ch1, char ch2) {
        if (ch1 == ch2) {
            return true;
        }
        return Character.toLowerCase(ch1) == Character.toLowerCase(ch2);
    }

    private static String dumpMatrix(String src, String dest, int[][] matrix) {
        StringBuffer s = new StringBuffer("");
        int cols = matrix.length - 1;
        int rows = matrix[0].length - 1;
        for (int i = 0; i < cols + 1; ++i) {
            for (int j = 0; j < rows + 1; ++j) {
                if (i == 0 && j == 0) {
                    s.append("\n ");
                    continue;
                }
                if (i == 0) {
                    s.append("|   ");
                    s.append(dest.charAt(j - 1));
                    continue;
                }
                if (j == 0) {
                    s.append(src.charAt(i - 1));
                    continue;
                }
                String num = Integer.toString(matrix[i - 1][j - 1]);
                int padding = 4 - num.length();
                s.append("|");
                for (int k = 0; k < padding; ++k) {
                    s.append(' ');
                }
                s.append(num);
            }
            s.append('\n');
        }
        return s.toString();
    }

    private static int minimum(int a, int b, int c, int d, int e) {
        int mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        if (d < mi) {
            mi = d;
        }
        if (e < mi) {
            mi = e;
        }
        return mi;
    }

    public static void main(String[] args) throws Exception {
        String input2;
        String input1;
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        int[][] matrix = new int[0][0];
        while ((input1 = stdin.readLine()) != null && input1.length() != 0 && (input2 = stdin.readLine()) != null && input2.length() != 0) {
            System.out.println(EditDistance.getDistance(input1, input2, matrix));
        }
        System.out.println("done");
    }
}

